/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.util;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.security.authentication.client.AccessToken;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpRequestConfig;
import co.cask.common.http.HttpRequests;
import co.cask.common.http.HttpResponse;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ArrayUtils;

public class RESTClient {
    private final HttpRequestConfig defaultConfig;
    private final HttpRequestConfig uploadConfig;
    private final int unavailableRetryLimit;

    public RESTClient(HttpRequestConfig defaultConfig, HttpRequestConfig uploadConfig, int retryLimit) {
        this.defaultConfig = defaultConfig;
        this.uploadConfig = uploadConfig;
        this.unavailableRetryLimit = retryLimit;
    }

    public static RESTClient create(ClientConfig clientConfig) {
        return new RESTClient(clientConfig.getDefaultHttpConfig(), clientConfig.getUploadHttpConfig(), clientConfig.getUnavailableRetryLimit());
    }

    public static RESTClient create(int unavailableRetryLimit) {
        return new RESTClient(HttpRequestConfig.DEFAULT, HttpRequestConfig.DEFAULT, unavailableRetryLimit);
    }

    public HttpResponse execute(HttpRequest request, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnAuthorizedAccessTokenException {
        return this.execute(HttpRequest.builder((HttpRequest)request).addHeaders(this.getAuthHeaders(accessToken)).build(), allowedErrorCodes);
    }

    public HttpResponse execute(HttpMethod httpMethod, URL url, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnAuthorizedAccessTokenException {
        return this.execute(HttpRequest.builder((HttpMethod)httpMethod, (URL)url).addHeaders(this.getAuthHeaders(accessToken)).build(), allowedErrorCodes);
    }

    public HttpResponse execute(HttpMethod httpMethod, URL url, Map<String, String> headers, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnAuthorizedAccessTokenException {
        return this.execute(HttpRequest.builder((HttpMethod)httpMethod, (URL)url).addHeaders(headers).addHeaders(this.getAuthHeaders(accessToken)).build(), allowedErrorCodes);
    }

    private HttpResponse execute(HttpRequest request, int ... allowedErrorCodes) throws IOException, UnAuthorizedAccessTokenException {
        HttpResponse response;
        int currentTry = 0;
        do {
            int responseCode;
            if ((responseCode = (response = HttpRequests.execute((HttpRequest)request, (HttpRequestConfig)this.defaultConfig)).getResponseCode()) == 401) {
                throw new UnAuthorizedAccessTokenException("Unauthorized status code received from the server.");
            }
            if (!this.isSuccessful(responseCode) && responseCode != 503 && !ArrayUtils.contains((int[])allowedErrorCodes, (int)responseCode)) {
                throw new IOException(responseCode + ": " + response.getResponseBodyAsString());
            }
            if (responseCode == 503) {
                ++currentTry;
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            return response;
        } while (currentTry <= this.unavailableRetryLimit);
        return response;
    }

    public HttpResponse upload(HttpRequest request, AccessToken accessToken, int ... allowedErrorCodes) throws IOException {
        HttpResponse response = HttpRequests.execute((HttpRequest)HttpRequest.builder((HttpRequest)request).addHeaders(this.getAuthHeaders(accessToken)).build(), (HttpRequestConfig)this.uploadConfig);
        int responseCode = response.getResponseCode();
        if (!this.isSuccessful(responseCode) && !ArrayUtils.contains((int[])allowedErrorCodes, (int)responseCode)) {
            throw new IOException(response.getResponseBodyAsString());
        }
        return response;
    }

    private boolean isSuccessful(int responseCode) {
        return 200 <= responseCode && responseCode <= 299;
    }

    private Map<String, String> getAuthHeaders(AccessToken accessToken) {
        ImmutableMap headers = ImmutableMap.of();
        if (accessToken != null) {
            headers = ImmutableMap.of((Object)"Authorization", (Object)(accessToken.getTokenType() + " " + accessToken.getValue()));
        }
        return headers;
    }
}

