/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.config;

import co.cask.cdap.common.conf.CConfiguration;
import co.cask.cdap.security.authentication.client.AccessToken;
import co.cask.common.http.HttpRequestConfig;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nullable;

public class ClientConfig {
    private static final CConfiguration CONF = CConfiguration.create();
    private static final int DEFAULT_UPLOAD_READ_TIMEOUT = 15000;
    private static final int DEFAULT_UPLOAD_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_SERVICE_UNAVAILABLE_RETRY_LIMIT = 50;
    private static final int DEFAULT_READ_TIMEOUT = 15000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final boolean DEFAULT_VERIFY_SSL_CERTIFICATE = true;
    private static final String DEFAULT_VERSION = "v2";
    private static final int DEFAULT_PORT = CONF.getInt("router.bind.port");
    private static final int DEFAULT_SSL_PORT = CONF.getInt("router.ssl.bind.port");
    private static final boolean DEFAULT_SSL_ENABLED = CONF.getBoolean("ssl.enabled");
    private static final String DEFAULT_HOST = CONF.get("router.bind.address");
    private HttpRequestConfig defaultHttpConfig;
    private HttpRequestConfig uploadHttpConfig;
    private boolean sslEnabled;
    private String hostname;
    private int port;
    private int unavailableRetryLimit;
    private String apiVersion;
    private Supplier<AccessToken> accessToken;
    private boolean verifySSLCert;

    private ClientConfig(String hostname, int port, boolean sslEnabled, int unavailableRetryLimit, String apiVersion, Supplier<AccessToken> accessToken, boolean verifySSLCert, HttpRequestConfig defaultHttpConfig, HttpRequestConfig uploadHttpConfig) {
        this.hostname = hostname;
        this.apiVersion = apiVersion;
        this.port = port;
        this.sslEnabled = sslEnabled;
        this.unavailableRetryLimit = unavailableRetryLimit;
        this.accessToken = accessToken;
        this.verifySSLCert = verifySSLCert;
        this.defaultHttpConfig = defaultHttpConfig;
        this.uploadHttpConfig = uploadHttpConfig;
    }

    public URL resolveURL(String path) throws MalformedURLException {
        return this.getBaseURI().resolve("/" + this.apiVersion + "/" + path).toURL();
    }

    public URI getBaseURI() {
        return URI.create(String.format("%s://%s:%d", this.sslEnabled ? "https" : "http", this.hostname, this.port));
    }

    public HttpRequestConfig getDefaultHttpConfig() {
        return this.defaultHttpConfig;
    }

    public HttpRequestConfig getUploadHttpConfig() {
        return this.uploadHttpConfig;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isVerifySSLCert() {
        return this.verifySSLCert;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    public int getUnavailableRetryLimit() {
        return this.unavailableRetryLimit;
    }

    public void setSSLEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    public void setHostname(String hostname) {
        Preconditions.checkArgument((hostname != null ? 1 : 0) != 0, (Object)"hostname cannot be null");
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public void setVerifySSLCert(boolean verifySSLCert) {
        this.verifySSLCert = verifySSLCert;
        this.defaultHttpConfig = new HttpRequestConfig(this.defaultHttpConfig.getConnectTimeout(), this.defaultHttpConfig.getReadTimeout(), verifySSLCert);
        this.uploadHttpConfig = new HttpRequestConfig(this.uploadHttpConfig.getConnectTimeout(), this.uploadHttpConfig.getReadTimeout(), verifySSLCert);
    }

    public void setAllTimeouts(int timeout) {
        this.defaultHttpConfig = new HttpRequestConfig(timeout, timeout, this.verifySSLCert);
        this.uploadHttpConfig = new HttpRequestConfig(timeout, timeout, this.verifySSLCert);
    }

    @Nullable
    public AccessToken getAccessToken() {
        return (AccessToken)this.accessToken.get();
    }

    public Supplier<AccessToken> getAccessTokenSupplier() {
        return this.accessToken;
    }

    public void setAccessToken(Supplier<AccessToken> accessToken) {
        this.accessToken = accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = Suppliers.ofInstance((Object)accessToken);
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_HOST;
    }

    static /* synthetic */ boolean access$100() {
        return DEFAULT_SSL_ENABLED;
    }

    public static final class Builder {
        private String hostname = ClientConfig.access$000();
        private Optional<Integer> port = Optional.absent();
        private boolean sslEnabled = ClientConfig.access$100();
        private String apiVersion = "v2";
        private Supplier<AccessToken> accessToken = Suppliers.ofInstance(null);
        private int uploadReadTimeoutMs = 15000;
        private int uploadConnectTimeoutMs = 15000;
        private int serviceUnavailableRetryLimit = 50;
        private int defaultReadTimeoutMs = 15000;
        private int defaultConnectTimeoutMs = 15000;
        private boolean verifySSLCert = true;

        public Builder() {
        }

        public Builder(ClientConfig clientConfig) {
            this.hostname = clientConfig.getHostname();
            this.port = Optional.of((Object)clientConfig.getPort());
            this.sslEnabled = clientConfig.isSSLEnabled();
            this.apiVersion = clientConfig.getApiVersion();
            this.accessToken = clientConfig.getAccessTokenSupplier();
            this.uploadReadTimeoutMs = clientConfig.getUploadHttpConfig().getReadTimeout();
            this.uploadConnectTimeoutMs = clientConfig.getUploadHttpConfig().getConnectTimeout();
            this.defaultReadTimeoutMs = clientConfig.getDefaultHttpConfig().getReadTimeout();
            this.defaultConnectTimeoutMs = clientConfig.getDefaultHttpConfig().getConnectTimeout();
            this.verifySSLCert = clientConfig.isVerifySSLCert();
        }

        public Builder setUploadReadTimeoutMs(int uploadReadTimeoutMs) {
            this.uploadReadTimeoutMs = uploadReadTimeoutMs;
            return this;
        }

        public Builder setUploadConnectTimeoutMs(int uploadConnectTimeoutMs) {
            this.uploadConnectTimeoutMs = uploadConnectTimeoutMs;
            return this;
        }

        public Builder setDefaultReadTimeoutMs(int defaultReadTimeoutMs) {
            this.defaultReadTimeoutMs = defaultReadTimeoutMs;
            return this;
        }

        public Builder setDefaultConnectTimeoutMs(int defaultConnectTimeoutMs) {
            this.defaultConnectTimeoutMs = defaultConnectTimeoutMs;
            return this;
        }

        public Builder setVerifySSLCert(boolean verifySSLCert) {
            this.verifySSLCert = verifySSLCert;
            return this;
        }

        public Builder setSSLEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public Builder setHostname(String hostname) {
            Preconditions.checkArgument((hostname != null ? 1 : 0) != 0, (Object)"hostname cannot be null");
            this.hostname = hostname;
            return this;
        }

        public Builder setPort(int port) {
            this.port = Optional.of((Object)port);
            return this;
        }

        public Builder setAccessToken(Supplier<AccessToken> accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public Builder setAccessToken(AccessToken accessToken) {
            this.accessToken = Suppliers.ofInstance((Object)accessToken);
            return this;
        }

        public Builder setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public Builder setServiceUnavailableRetryLimit(int retry) {
            this.serviceUnavailableRetryLimit = retry;
            return this;
        }

        public ClientConfig build() {
            return new ClientConfig(this.hostname, (Integer)this.port.or((Object)(this.sslEnabled ? DEFAULT_SSL_PORT : DEFAULT_PORT)), this.sslEnabled, this.serviceUnavailableRetryLimit, this.apiVersion, this.accessToken, this.verifySSLCert, new HttpRequestConfig(this.defaultConnectTimeoutMs, this.defaultReadTimeoutMs, this.verifySSLCert), new HttpRequestConfig(this.uploadConnectTimeoutMs, this.uploadReadTimeoutMs, this.verifySSLCert));
        }
    }
}

