/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.service.ServiceSpecification;
import co.cask.cdap.api.service.http.HttpServiceHandlerSpecification;
import co.cask.cdap.api.service.http.ServiceHttpEndpoint;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.NotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;

public class ServiceClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ServiceClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public ServiceSpecification get(String appId, String serviceId) throws IOException, UnAuthorizedAccessTokenException, NotFoundException {
        URL url = this.config.resolveURL(String.format("apps/%s/services/%s", appId, serviceId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or service ", appId + "/" + serviceId);
        }
        return (ServiceSpecification)ObjectResponse.fromJsonBody((HttpResponse)response, ServiceSpecification.class).getResponseObject();
    }

    public List<ServiceHttpEndpoint> getEndpoints(String appId, String serviceId) throws IOException, UnAuthorizedAccessTokenException, NotFoundException {
        ServiceSpecification specification = this.get(appId, serviceId);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (HttpServiceHandlerSpecification handlerSpecification : specification.getHandlers().values()) {
            builder.addAll((Iterable)handlerSpecification.getEndpoints());
        }
        return builder.build();
    }

    public URL getServiceURL(String appId, String serviceId) throws NotFoundException, IOException, UnAuthorizedAccessTokenException {
        this.get(appId, serviceId);
        return this.config.resolveURL(String.format("apps/%s/services/%s/methods/", appId, serviceId));
    }
}

