/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.NotFoundException;
import co.cask.cdap.client.exception.ProgramNotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.DistributedProgramLiveInfo;
import co.cask.cdap.proto.Instances;
import co.cask.cdap.proto.ProgramStatus;
import co.cask.cdap.proto.ProgramType;
import co.cask.cdap.proto.RunRecord;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpRequest;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;

public class ProgramClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ProgramClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public void start(String appId, ProgramType programType, String programName, Map<String, String> runtimeArgs) throws IOException, ProgramNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/start", appId, programType.getCategoryName(), programName));
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson(runtimeArgs)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programName);
        }
    }

    public void start(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/start", appId, programType.getCategoryName(), programName));
        HttpRequest request = HttpRequest.post((URL)url).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programName);
        }
    }

    public void stop(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/stop", appId, programType.getCategoryName(), programName));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programName);
        }
    }

    public String getStatus(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/status", appId, programType.getCategoryName(), programName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new ProgramNotFoundException(programType, appId, programName);
        }
        return ((ProgramStatus)ObjectResponse.fromJsonBody((HttpResponse)response, ProgramStatus.class).getResponseObject()).getStatus();
    }

    public void waitForStatus(final String appId, final ProgramType programType, final String programId, String status, long timeout, TimeUnit timeoutUnit) throws UnAuthorizedAccessTokenException, IOException, ProgramNotFoundException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)status, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return ProgramClient.this.getStatus(appId, programType, programId);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), UnAuthorizedAccessTokenException.class);
            Throwables.propagateIfPossible((Throwable)e.getCause(), ProgramNotFoundException.class);
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class);
        }
    }

    public DistributedProgramLiveInfo getLiveInfo(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/live-info", appId, programType.getCategoryName(), programName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programName);
        }
        return (DistributedProgramLiveInfo)ObjectResponse.fromJsonBody((HttpResponse)response, DistributedProgramLiveInfo.class).getResponseObject();
    }

    public int getFlowletInstances(String appId, String flowId, String flowletId) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/flows/%s/flowlets/%s/instances", appId, flowId, flowletId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or flow or flowlet", appId + "/" + flowId + "/" + flowletId);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setFlowletInstances(String appId, String flowId, String flowletId, int instances) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/flows/%s/flowlets/%s/instances", appId, flowId, flowletId));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or flow or flowlet", appId + "/" + flowId + "/" + flowletId);
        }
    }

    @Deprecated
    public int getProcedureInstances(String appId, String procedureId) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/procedures/%s/instances", appId, procedureId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or procedure", appId + "/" + procedureId);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    @Deprecated
    public void setProcedureInstances(String appId, String procedureId, int instances) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/procedures/%s/instances", appId, procedureId));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or procedure", appId + "/" + procedureId);
        }
    }

    public int getServiceRunnableInstances(String appId, String serviceId, String runnableId) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/services/%s/runnables/%s/instances", appId, serviceId, runnableId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or service or runnable", appId + "/" + serviceId + "/" + runnableId);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setServiceRunnableInstances(String appId, String serviceId, String runnableId, int instances) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/services/%s/runnables/%s/instances", appId, serviceId, runnableId));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or service or runnable", appId + "/" + serviceId + "/" + runnableId);
        }
    }

    public List<RunRecord> getProgramRuns(String appId, ProgramType programType, String programId, String state, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        String queryParams = String.format("%s=%s&%s=%d&%s=%d&%s=%d", "status", state, "start", startTime, "end", endTime, "limit", limit);
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/runs?%s", appId, programType.getCategoryName(), programId, queryParams));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or " + programType.getCategoryName(), appId + "/" + programId);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<RunRecord>>(){}).getResponseObject();
    }

    public List<RunRecord> getAllProgramRuns(String appId, ProgramType programType, String programId, long startTime, long endTime, int limit) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        String queryParams = String.format("%s=%d&%s=%d&%s=%d", "start", startTime, "end", endTime, "limit", limit);
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/runs?%s", appId, programType.getCategoryName(), programId, queryParams));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or " + programType.getCategoryName(), appId + "/" + programId);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<RunRecord>>(){}).getResponseObject();
    }

    public String getProgramLogs(String appId, ProgramType programType, String programId, long start, long stop) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/logs?start=%d&stop=%d", appId, programType.getCategoryName(), programId, start, stop));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programId);
        }
        return new String(response.getResponseBody(), Charsets.UTF_8);
    }

    public String getServiceRunnableLogs(String appId, String serviceId, String runnableId, long start, long stop) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/services/%s/runnables/%s/logs?start=%d&stop=%d", appId, serviceId, runnableId, start, stop));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or service or runnable", appId + "/" + serviceId + "/" + runnableId);
        }
        return new String(response.getResponseBody(), Charsets.UTF_8);
    }

    public Map<String, String> getRuntimeArgs(String appId, ProgramType programType, String programId) throws IOException, UnAuthorizedAccessTokenException, ProgramNotFoundException {
        String path = String.format("apps/%s/%s/%s/runtimeargs", appId, programType.getCategoryName(), programId);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveURL(path), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programId);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setRuntimeArgs(String appId, ProgramType programType, String programId, Map<String, String> runtimeArgs) throws IOException, UnAuthorizedAccessTokenException, ProgramNotFoundException {
        String path = String.format("apps/%s/%s/%s/runtimeargs", appId, programType.getCategoryName(), programId);
        HttpRequest request = HttpRequest.put((URL)this.config.resolveURL(path)).withBody(GSON.toJson(runtimeArgs)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programId);
        }
    }
}

