/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URL;
import javax.inject.Inject;

public class MetricsClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public MetricsClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public JsonObject getMetric(String scope, String context, String metric, String timeRange) throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("metrics/%s/%s/%s?%s", scope, context, metric, timeRange));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (JsonObject)ObjectResponse.fromJsonBody((HttpResponse)response, JsonObject.class).getResponseObject();
    }
}

