/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.DatasetTypeNotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.utils.Tasks;
import co.cask.cdap.proto.DatasetTypeMeta;
import co.cask.common.http.HttpMethod;
import co.cask.common.http.HttpResponse;
import co.cask.common.http.ObjectResponse;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;

public class DatasetTypeClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public DatasetTypeClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public List<DatasetTypeMeta> list() throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("data/types");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<DatasetTypeMeta>>(){}).getResponseObject();
    }

    public DatasetTypeMeta get(String typeName) throws DatasetTypeNotFoundException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/types/%s", typeName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new DatasetTypeNotFoundException(typeName);
        }
        return (DatasetTypeMeta)ObjectResponse.fromJsonBody((HttpResponse)response, DatasetTypeMeta.class).getResponseObject();
    }

    public boolean exists(String typeName) throws DatasetTypeNotFoundException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/types/%s", typeName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        return response.getResponseCode() != 404;
    }

    public void waitForExists(final String typeName, long timeout, TimeUnit timeoutUnit) throws IOException, UnAuthorizedAccessTokenException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)true, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetTypeClient.this.exists(typeName);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnAuthorizedAccessTokenException.class);
        }
    }

    public void waitForDeleted(final String moduleName, long timeout, TimeUnit timeoutUnit) throws IOException, UnAuthorizedAccessTokenException, TimeoutException, InterruptedException {
        try {
            Tasks.waitFor((Object)false, (Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return DatasetTypeClient.this.exists(moduleName);
                }
            }, (long)timeout, (TimeUnit)timeoutUnit, (long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfPossible((Throwable)e.getCause(), IOException.class, UnAuthorizedAccessTokenException.class);
        }
    }
}

