/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.util;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.common.http.HttpMethod;
import co.cask.cdap.common.http.HttpRequest;
import co.cask.cdap.common.http.HttpRequestConfig;
import co.cask.cdap.common.http.HttpRequests;
import co.cask.cdap.common.http.HttpResponse;
import co.cask.cdap.security.authentication.client.AccessToken;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class RESTClient {
    private final HttpRequestConfig defaultConfig;
    private final HttpRequestConfig uploadConfig;

    private RESTClient(HttpRequestConfig defaultConfig, HttpRequestConfig uploadConfig) {
        this.defaultConfig = defaultConfig;
        this.uploadConfig = uploadConfig;
    }

    public static RESTClient create(ClientConfig config) {
        return new RESTClient(config.getDefaultConfig(), config.getUploadConfig());
    }

    public HttpResponse execute(HttpRequest request, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnAuthorizedAccessTokenException {
        return this.execute(HttpRequest.builder((HttpRequest)request).addHeaders(this.getAuthHeaders(accessToken)).build(), allowedErrorCodes);
    }

    public HttpResponse execute(HttpMethod httpMethod, URL url, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnAuthorizedAccessTokenException {
        return this.execute(HttpRequest.builder((HttpMethod)httpMethod, (URL)url).addHeaders(this.getAuthHeaders(accessToken)).build(), allowedErrorCodes);
    }

    public HttpResponse execute(HttpMethod httpMethod, URL url, Map<String, String> headers, AccessToken accessToken, int ... allowedErrorCodes) throws IOException, UnAuthorizedAccessTokenException {
        return this.execute(HttpRequest.builder((HttpMethod)httpMethod, (URL)url).addHeaders(headers).addHeaders(this.getAuthHeaders(accessToken)).build(), allowedErrorCodes);
    }

    private HttpResponse execute(HttpRequest request, int ... allowedErrorCodes) throws IOException, UnAuthorizedAccessTokenException {
        HttpResponse response = HttpRequests.execute((HttpRequest)request, (HttpRequestConfig)this.defaultConfig);
        int responseCode = response.getResponseCode();
        if (responseCode == 401) {
            throw new UnAuthorizedAccessTokenException("Unauthorized status code received from the server.");
        }
        if (!this.isSuccessful(responseCode) && !ArrayUtils.contains((int[])allowedErrorCodes, (int)responseCode)) {
            throw new IOException(responseCode + ": " + response.getResponseBodyAsString());
        }
        return response;
    }

    public HttpResponse upload(HttpRequest request, AccessToken accessToken, int ... allowedErrorCodes) throws IOException {
        HttpResponse response = HttpRequests.execute((HttpRequest)HttpRequest.builder((HttpRequest)request).addHeaders(this.getAuthHeaders(accessToken)).build(), (HttpRequestConfig)this.uploadConfig);
        int responseCode = response.getResponseCode();
        if (!this.isSuccessful(responseCode) && !ArrayUtils.contains((int[])allowedErrorCodes, (int)responseCode)) {
            throw new IOException(response.getResponseBodyAsString());
        }
        return response;
    }

    private boolean isSuccessful(int responseCode) {
        return 200 <= responseCode && responseCode <= 299;
    }

    private Map<String, String> getAuthHeaders(AccessToken accessToken) {
        ImmutableMap headers = ImmutableMap.of();
        if (accessToken != null) {
            headers = ImmutableMap.of((Object)"Authorization", (Object)(accessToken.getTokenType() + " " + accessToken.getValue()));
        }
        return headers;
    }
}

