/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.config;

import co.cask.cdap.common.http.HttpRequestConfig;
import co.cask.cdap.security.authentication.client.AccessToken;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class ClientConfig {
    private static final HttpRequestConfig DEFAULT_UPLOAD_CONFIG = new HttpRequestConfig(0, 0);
    private static final HttpRequestConfig DEFAULT_CONFIG = new HttpRequestConfig(15000, 15000);
    private static final boolean DEFAULT_IS_SSL_ENABLED = false;
    private static final String DEFAULT_VERSION = "v2";
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final int DEFAULT_PORT = 10000;
    private final HttpRequestConfig defaultConfig;
    private final HttpRequestConfig uploadConfig;
    private String protocol;
    private URI baseURI;
    private String hostname;
    private int port;
    private AccessToken accessToken;

    public ClientConfig(String hostname, int port, HttpRequestConfig defaultConfig, HttpRequestConfig uploadConfig, AccessToken accessToken) {
        this(hostname, port, defaultConfig, uploadConfig, false, accessToken);
    }

    public ClientConfig(String hostname, int port, HttpRequestConfig defaultConfig, HttpRequestConfig uploadConfig, boolean isSslEnabled, AccessToken accessToken) {
        this.defaultConfig = defaultConfig;
        this.uploadConfig = uploadConfig;
        this.hostname = hostname;
        this.port = port;
        this.protocol = isSslEnabled ? HTTPS : HTTP;
        this.accessToken = accessToken;
        this.baseURI = URI.create(String.format("%s://%s:%d", this.protocol, hostname, port));
    }

    public ClientConfig(URI uri, AccessToken accessToken) {
        this(uri.getHost(), uri.getPort(), DEFAULT_CONFIG, DEFAULT_UPLOAD_CONFIG, HTTPS.equals(uri.getScheme()), accessToken);
    }

    public ClientConfig(String hostname, int port, AccessToken accessToken) {
        this(hostname, port, DEFAULT_CONFIG, DEFAULT_UPLOAD_CONFIG, accessToken);
    }

    public ClientConfig(String hostname, AccessToken accessToken) {
        this(hostname, 10000, DEFAULT_CONFIG, DEFAULT_UPLOAD_CONFIG, accessToken);
    }

    public URL resolveURL(String path) throws MalformedURLException {
        return this.baseURI.resolve("/v2/" + path).toURL();
    }

    public HttpRequestConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public HttpRequestConfig getUploadConfig() {
        return this.uploadConfig;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setHostnameAndPort(String hostname, int port, boolean isSslEnabled) {
        this.hostname = hostname;
        this.port = port;
        this.protocol = isSslEnabled ? HTTPS : HTTP;
        this.baseURI = URI.create(String.format("%s://%s:%d", this.protocol, hostname, port));
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

