/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.http.HttpMethod;
import co.cask.cdap.common.http.HttpResponse;
import co.cask.cdap.common.http.ObjectResponse;
import co.cask.cdap.proto.ServiceMeta;
import java.io.IOException;
import java.net.URL;
import javax.inject.Inject;

public class ServiceClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ServiceClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public ServiceMeta get(String appId, String serviceId) throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/services/%s", appId, serviceId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (ServiceMeta)ObjectResponse.fromJsonBody((HttpResponse)response, ServiceMeta.class).getResponseObject();
    }
}

