/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.BadRequestException;
import co.cask.cdap.client.exception.QueryNotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.http.HttpMethod;
import co.cask.cdap.common.http.HttpRequest;
import co.cask.cdap.common.http.HttpResponse;
import co.cask.cdap.common.http.ObjectResponse;
import co.cask.cdap.proto.ColumnDesc;
import co.cask.cdap.proto.QueryHandle;
import co.cask.cdap.proto.QueryResult;
import co.cask.cdap.proto.QueryStatus;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;

public class QueryClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public QueryClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public QueryHandle execute(String query) throws IOException, BadRequestException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("data/explore/queries");
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson((Object)ImmutableMap.of((Object)"query", (Object)query))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 400);
        if (response.getResponseCode() == 400) {
            throw new BadRequestException("The query is not well-formed or contains an error, such as a nonexistent table name: " + query);
        }
        return (QueryHandle)ObjectResponse.fromJsonBody((HttpResponse)response, QueryHandle.class).getResponseObject();
    }

    public QueryStatus getStatus(QueryHandle queryHandle) throws IOException, QueryNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/explore/queries/%s/status", queryHandle.getHandle()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new QueryNotFoundException(queryHandle.getHandle());
        }
        return (QueryStatus)ObjectResponse.fromJsonBody((HttpResponse)response, QueryStatus.class).getResponseObject();
    }

    public List<ColumnDesc> getSchema(QueryHandle queryHandle) throws IOException, QueryNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/explore/queries/%s/schema", queryHandle.getHandle()));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new QueryNotFoundException(queryHandle.getHandle());
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<ColumnDesc>>(){}).getResponseObject();
    }

    public List<QueryResult> getResults(QueryHandle queryHandle, int batchSize) throws IOException, QueryNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/explore/queries/%s/next", queryHandle.getHandle()));
        HttpRequest request = HttpRequest.post((URL)url).withBody(GSON.toJson((Object)ImmutableMap.of((Object)"size", (Object)batchSize))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new QueryNotFoundException(queryHandle.getHandle());
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<QueryResult>>(){}).getResponseObject();
    }

    public void delete(QueryHandle queryHandle) throws IOException, QueryNotFoundException, BadRequestException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/explore/queries/%s", queryHandle.getHandle()));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404, 400);
        if (response.getResponseCode() == 404) {
            throw new QueryNotFoundException(queryHandle.getHandle());
        }
        if (response.getResponseCode() == 400) {
            throw new BadRequestException("The query '" + queryHandle + "' was not in a state that could be closed;" + " either wait until it is finished, or cancel it");
        }
    }

    public void cancel(QueryHandle queryHandle) throws IOException, QueryNotFoundException, BadRequestException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/explore/queries/%s/cancel", queryHandle.getHandle()));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404, 400);
        if (response.getResponseCode() == 404) {
            throw new QueryNotFoundException(queryHandle.getHandle());
        }
        if (response.getResponseCode() == 400) {
            throw new BadRequestException("The query '" + queryHandle + "' was not in a state that can be canceled");
        }
    }
}

