/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.NotFoundException;
import co.cask.cdap.client.exception.ProgramNotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.http.HttpMethod;
import co.cask.cdap.common.http.HttpRequest;
import co.cask.cdap.common.http.HttpResponse;
import co.cask.cdap.common.http.ObjectResponse;
import co.cask.cdap.proto.DistributedProgramLiveInfo;
import co.cask.cdap.proto.Instances;
import co.cask.cdap.proto.ProgramStatus;
import co.cask.cdap.proto.ProgramType;
import co.cask.cdap.proto.RunRecord;
import com.google.common.base.Charsets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class ProgramClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ProgramClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public void start(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/start", appId, programType.getCategoryName(), programName));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programName);
        }
    }

    public void stop(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/stop", appId, programType.getCategoryName(), programName));
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programName);
        }
    }

    public String getStatus(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/status", appId, programType.getCategoryName(), programName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (404 == response.getResponseCode()) {
            throw new ProgramNotFoundException(programType, appId, programName);
        }
        return ((ProgramStatus)ObjectResponse.fromJsonBody((HttpResponse)response, ProgramStatus.class).getResponseObject()).getStatus();
    }

    public DistributedProgramLiveInfo getLiveInfo(String appId, ProgramType programType, String programName) throws IOException, ProgramNotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/live-info", appId, programType.getCategoryName(), programName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programName);
        }
        return (DistributedProgramLiveInfo)ObjectResponse.fromJsonBody((HttpResponse)response, DistributedProgramLiveInfo.class).getResponseObject();
    }

    public int getFlowletInstances(String appId, String flowId, String flowletId) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/flows/%s/flowlets/%s/instances", appId, flowId, flowletId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or flow or flowlet", appId + "/" + flowId + "/" + flowletId);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setFlowletInstances(String appId, String flowId, String flowletId, int instances) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/flows/%s/flowlets/%s/instances", appId, flowId, flowletId));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or flow or flowlet", appId + "/" + flowId + "/" + flowletId);
        }
    }

    public int getProcedureInstances(String appId, String procedureId) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/procedures/%s/instances", appId, procedureId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or procedure", appId + "/" + procedureId);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setProcedureInstances(String appId, String procedureId, int instances) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/procedures/%s/instances", appId, procedureId));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or procedure", appId + "/" + procedureId);
        }
    }

    public int getServiceRunnableInstances(String appId, String serviceId, String runnableId) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/services/%s/runnables/%s/instances", appId, serviceId, runnableId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or service or runnable", appId + "/" + serviceId + "/" + runnableId);
        }
        return ((Instances)ObjectResponse.fromJsonBody((HttpResponse)response, Instances.class).getResponseObject()).getInstances();
    }

    public void setServiceRunnableInstances(String appId, String serviceId, String runnableId, int instances) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/services/%s/runnables/%s/instances", appId, serviceId, runnableId));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)new Instances(instances))).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or service or runnable", appId + "/" + serviceId + "/" + runnableId);
        }
    }

    public List<RunRecord> getServiceRunnableHistory(String appId, String serviceId, String runnableId) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/services/%s/runnables/%s/history", appId, serviceId, runnableId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or service or runnable", appId + "/" + serviceId + "/" + runnableId);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<RunRecord>>(){}).getResponseObject();
    }

    public List<RunRecord> getProgramHistory(String appId, ProgramType programType, String programId) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/history", appId, programType.getCategoryName(), programId));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or " + programType.getCategoryName(), appId + "/" + programId);
        }
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<RunRecord>>(){}).getResponseObject();
    }

    public String getProgramLogs(String appId, ProgramType programType, String programId, long start, long stop) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/%s/%s/logs?start=%d&stop=%d", appId, programType.getCategoryName(), programId, start, stop));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programId);
        }
        return new String(response.getResponseBody(), Charsets.UTF_8);
    }

    public String getServiceRunnableLogs(String appId, String serviceId, String runnableId, long start, long stop) throws IOException, NotFoundException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("apps/%s/services/%s/runnables/%s/logs?start=%d&stop=%d", appId, serviceId, runnableId, start, stop));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new NotFoundException("application or service or runnable", appId + "/" + serviceId + "/" + runnableId);
        }
        return new String(response.getResponseBody(), Charsets.UTF_8);
    }

    public Map<String, String> getRuntimeArgs(String appId, ProgramType programType, String programId) throws IOException, UnAuthorizedAccessTokenException, ProgramNotFoundException {
        String path = String.format("apps/%s/%s/%s/runtimeargs", appId, programType.getCategoryName(), programId);
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveURL(path), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programId);
        }
        return (Map)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<Map<String, String>>(){}).getResponseObject();
    }

    public void setRuntimeArgs(String appId, ProgramType programType, String programId, Map<String, String> runtimeArgs) throws IOException, UnAuthorizedAccessTokenException, ProgramNotFoundException {
        String path = String.format("apps/%s/%s/%s/runtimeargs", appId, programType.getCategoryName(), programId);
        HttpRequest request = HttpRequest.put((URL)this.config.resolveURL(path)).withBody(GSON.toJson(runtimeArgs)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ProgramNotFoundException(programType, appId, programId);
        }
    }
}

