/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.http.HttpMethod;
import co.cask.cdap.common.http.HttpResponse;
import co.cask.cdap.common.http.ObjectResponse;
import co.cask.cdap.proto.DatasetTypeMeta;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.inject.Inject;

public class DatasetTypeClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public DatasetTypeClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public List<DatasetTypeMeta> list() throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("data/types");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<DatasetTypeMeta>>(){}).getResponseObject();
    }

    public DatasetTypeMeta get(String typeName) throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/types/%s", typeName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (DatasetTypeMeta)ObjectResponse.fromJsonBody((HttpResponse)response, DatasetTypeMeta.class).getResponseObject();
    }
}

