/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.AlreadyExistsException;
import co.cask.cdap.client.exception.BadRequestException;
import co.cask.cdap.client.exception.DatasetModuleAlreadyExistsException;
import co.cask.cdap.client.exception.DatasetModuleCannotBeDeletedException;
import co.cask.cdap.client.exception.DatasetModuleNotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.http.HttpMethod;
import co.cask.cdap.common.http.HttpRequest;
import co.cask.cdap.common.http.HttpResponse;
import co.cask.cdap.common.http.ObjectResponse;
import co.cask.cdap.proto.DatasetModuleMeta;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class DatasetModuleClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public DatasetModuleClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public List<DatasetModuleMeta> list() throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("data/modules");
        return (List)ObjectResponse.fromJsonBody((HttpResponse)this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]), (TypeToken)new TypeToken<List<DatasetModuleMeta>>(){}).getResponseObject();
    }

    public void add(String moduleName, String className, File moduleJarFile) throws BadRequestException, AlreadyExistsException, IOException {
        URL url = this.config.resolveURL(String.format("data/modules/%s", moduleName));
        ImmutableMap headers = ImmutableMap.of((Object)"X-Class-Name", (Object)className);
        HttpRequest request = HttpRequest.put((URL)url).addHeaders((Map)headers).withBody(moduleJarFile).build();
        HttpResponse response = this.restClient.upload(request, this.config.getAccessToken(), 400, 409);
        if (response.getResponseCode() == 400) {
            throw new BadRequestException(String.format("Module jar file does not exist: %s", moduleJarFile));
        }
        if (response.getResponseCode() == 409) {
            throw new DatasetModuleAlreadyExistsException(moduleName);
        }
    }

    public void delete(String moduleName) throws DatasetModuleCannotBeDeletedException, DatasetModuleNotFoundException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/modules/%s", moduleName));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 409, 404);
        if (response.getResponseCode() == 409) {
            throw new DatasetModuleCannotBeDeletedException(moduleName);
        }
        if (response.getResponseCode() == 404) {
            throw new DatasetModuleNotFoundException(moduleName);
        }
    }

    public void deleteAll() throws DatasetModuleCannotBeDeletedException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("data/modules");
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 409);
        if (response.getResponseCode() == 409) {
            throw new DatasetModuleCannotBeDeletedException(null);
        }
    }

    public DatasetModuleMeta get(String moduleName) throws DatasetModuleNotFoundException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/modules/%s", moduleName));
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new DatasetModuleNotFoundException(moduleName);
        }
        return (DatasetModuleMeta)ObjectResponse.fromJsonBody((HttpResponse)response, DatasetModuleMeta.class).getResponseObject();
    }
}

