/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.api.dataset.DatasetSpecification;
import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.DatasetAlreadyExistsException;
import co.cask.cdap.client.exception.DatasetNotFoundException;
import co.cask.cdap.client.exception.DatasetTypeNotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.http.HttpMethod;
import co.cask.cdap.common.http.HttpRequest;
import co.cask.cdap.common.http.HttpResponse;
import co.cask.cdap.common.http.ObjectResponse;
import co.cask.cdap.proto.DatasetInstanceConfiguration;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class DatasetClient {
    private static final Gson GSON = new Gson();
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public DatasetClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public List<DatasetSpecification> list() throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("data/datasets");
        HttpResponse response = this.restClient.execute(HttpMethod.GET, url, this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<DatasetSpecification>>(){}).getResponseObject();
    }

    public void create(String datasetName, DatasetInstanceConfiguration properties) throws DatasetTypeNotFoundException, DatasetAlreadyExistsException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/datasets/%s", datasetName));
        HttpRequest request = HttpRequest.put((URL)url).withBody(GSON.toJson((Object)properties)).build();
        HttpResponse response = this.restClient.execute(request, this.config.getAccessToken(), 404, 409);
        if (response.getResponseCode() == 404) {
            throw new DatasetTypeNotFoundException(properties.getTypeName());
        }
        if (response.getResponseCode() == 409) {
            throw new DatasetAlreadyExistsException(datasetName);
        }
    }

    public void create(String datasetName, String typeName) throws DatasetTypeNotFoundException, DatasetAlreadyExistsException, IOException, UnAuthorizedAccessTokenException {
        this.create(datasetName, new DatasetInstanceConfiguration(typeName, (Map)ImmutableMap.of()));
    }

    public void delete(String datasetName) throws DatasetNotFoundException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/datasets/%s", datasetName));
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new DatasetNotFoundException(datasetName);
        }
    }

    public void truncate(String datasetName) throws IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL(String.format("data/datasets/%s/admin/truncate", datasetName));
        this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), new int[0]);
    }
}

