/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client;

import co.cask.cdap.client.config.ClientConfig;
import co.cask.cdap.client.exception.ApplicationNotFoundException;
import co.cask.cdap.client.exception.UnAuthorizedAccessTokenException;
import co.cask.cdap.client.util.RESTClient;
import co.cask.cdap.common.http.HttpMethod;
import co.cask.cdap.common.http.HttpRequest;
import co.cask.cdap.common.http.HttpResponse;
import co.cask.cdap.common.http.ObjectResponse;
import co.cask.cdap.proto.ApplicationRecord;
import co.cask.cdap.proto.ProgramRecord;
import co.cask.cdap.proto.ProgramType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class ApplicationClient {
    private final RESTClient restClient;
    private final ClientConfig config;

    @Inject
    public ApplicationClient(ClientConfig config) {
        this.config = config;
        this.restClient = RESTClient.create(config);
    }

    public List<ApplicationRecord> list() throws IOException, UnAuthorizedAccessTokenException {
        HttpResponse response = this.restClient.execute(HttpMethod.GET, this.config.resolveURL("apps"), this.config.getAccessToken(), new int[0]);
        return (List)ObjectResponse.fromJsonBody((HttpResponse)response, (TypeToken)new TypeToken<List<ApplicationRecord>>(){}).getResponseObject();
    }

    public void delete(String appId) throws ApplicationNotFoundException, IOException, UnAuthorizedAccessTokenException {
        HttpResponse response = this.restClient.execute(HttpMethod.DELETE, this.config.resolveURL("apps/" + appId), this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(appId);
        }
    }

    public void deploy(File jarFile) throws IOException {
        URL url = this.config.resolveURL("apps");
        ImmutableMap headers = ImmutableMap.of((Object)"X-Archive-Name", (Object)jarFile.getName());
        HttpRequest request = HttpRequest.post((URL)url).addHeaders((Map)headers).withBody(jarFile).build();
        this.restClient.upload(request, this.config.getAccessToken(), new int[0]);
    }

    public void promote(String appId) throws ApplicationNotFoundException, IOException, UnAuthorizedAccessTokenException {
        URL url = this.config.resolveURL("apps/" + appId);
        HttpResponse response = this.restClient.execute(HttpMethod.POST, url, this.config.getAccessToken(), 404);
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(appId);
        }
    }

    public List<ProgramRecord> listAllPrograms(ProgramType programType) throws IOException, UnAuthorizedAccessTokenException {
        Preconditions.checkArgument((boolean)programType.isListable());
        URL url = this.config.resolveURL(programType.getCategoryName());
        HttpRequest request = HttpRequest.get((URL)url).build();
        ObjectResponse response = ObjectResponse.fromJsonBody((HttpResponse)this.restClient.execute(request, this.config.getAccessToken(), new int[0]), (TypeToken)new TypeToken<List<ProgramRecord>>(){});
        return (List)response.getResponseObject();
    }

    public Map<ProgramType, List<ProgramRecord>> listAllPrograms() throws IOException, UnAuthorizedAccessTokenException {
        ImmutableMap.Builder allPrograms = ImmutableMap.builder();
        for (ProgramType programType : ProgramType.values()) {
            if (!programType.isListable()) continue;
            ArrayList programRecords = Lists.newArrayList();
            programRecords.addAll(this.listAllPrograms(programType));
            allPrograms.put((Object)programType, (Object)programRecords);
        }
        return allPrograms.build();
    }

    public List<ProgramRecord> listPrograms(String appId, ProgramType programType) throws ApplicationNotFoundException, IOException, UnAuthorizedAccessTokenException {
        Preconditions.checkArgument((boolean)programType.isListable());
        URL url = this.config.resolveURL(String.format("apps/%s/%s", appId, programType.getCategoryName()));
        HttpRequest request = HttpRequest.get((URL)url).build();
        ObjectResponse response = ObjectResponse.fromJsonBody((HttpResponse)this.restClient.execute(request, this.config.getAccessToken(), 404), (TypeToken)new TypeToken<List<ProgramRecord>>(){});
        if (response.getResponseCode() == 404) {
            throw new ApplicationNotFoundException(appId);
        }
        return (List)response.getResponseObject();
    }

    public Map<ProgramType, List<ProgramRecord>> listPrograms(String appId) throws ApplicationNotFoundException, IOException, UnAuthorizedAccessTokenException {
        ImmutableMap.Builder allPrograms = ImmutableMap.builder();
        for (ProgramType programType : ProgramType.values()) {
            if (!programType.isListable()) continue;
            ArrayList programRecords = Lists.newArrayList();
            programRecords.addAll(this.listPrograms(appId, programType));
            allPrograms.put((Object)programType, (Object)programRecords);
        }
        return allPrograms.build();
    }
}

