/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.app;

import co.cask.cdap.api.Config;
import co.cask.cdap.api.app.AbstractApplication;
import co.cask.cdap.api.data.stream.Stream;
import co.cask.cdap.api.flow.Flow;
import co.cask.cdap.api.schedule.Schedules;
import co.cask.cdap.api.service.http.HttpServiceHandler;
import co.cask.cdap.api.spark.Spark;
import co.cask.cdap.client.app.FakeDataset;
import co.cask.cdap.client.app.FakeDatasetModule;
import co.cask.cdap.client.app.FakeFlow;
import co.cask.cdap.client.app.FakeSpark;
import co.cask.cdap.client.app.FakeWorkflow;
import co.cask.cdap.client.app.PingService;
import co.cask.cdap.client.app.PrefixedEchoHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;

public class FakeApp
extends AbstractApplication<AppConfig> {
    public static final String NAME = "FakeApp";
    public static final String STREAM_NAME = "fakeStream";
    public static final String DS_NAME = "fakeds";
    public static final String TIME_SCHEDULE_NAME = "someSchedule";
    public static final String SCHEDULE_CRON = "0 0 1 1 *";
    public static final String STREAM_SCHEDULE_NAME = "streamSchedule";
    public static final int STREAM_TRIGGER_MB = 10000;
    public static final List<String> FLOWS = Lists.newArrayList((Object[])new String[]{"FakeFlow"});
    public static final List<String> MAPREDUCES = Lists.newArrayList();
    public static final List<String> SPARK = Lists.newArrayList((Object[])new String[]{"FakeSparkProgram"});
    public static final List<String> WORKFLOWS = Lists.newArrayList((Object[])new String[]{"FakeWorkflow"});
    public static final List<String> SERVICES = Lists.newArrayList((Object[])new String[]{"pingService", "echoHandler"});
    public static final List<String> ALL_PROGRAMS = ImmutableList.builder().addAll(FLOWS).addAll(MAPREDUCES).addAll(WORKFLOWS).addAll(SPARK).addAll(SERVICES).build();

    public void configure() {
        this.setName(NAME);
        this.addStream(new Stream(STREAM_NAME));
        this.addDatasetModule("fakeDSModule", FakeDatasetModule.class);
        this.createDataset(DS_NAME, FakeDataset.class.getName());
        this.addFlow((Flow)new FakeFlow());
        this.addSpark((Spark)new FakeSpark());
        this.addWorkflow(new FakeWorkflow());
        AppConfig config = (AppConfig)this.getConfig();
        if (config.addTimeSchedule) {
            this.scheduleWorkflow(Schedules.builder((String)config.timeScheduleName).createTimeSchedule(config.timeScheduleCron), "FakeWorkflow");
        }
        if (config.addSizeSchedule) {
            this.scheduleWorkflow(Schedules.builder((String)config.sizeScheduleName).createDataSchedule(Schedules.Source.STREAM, STREAM_NAME, 10000), "FakeWorkflow");
        }
        this.addService("pingService", (HttpServiceHandler)new PingService(), new HttpServiceHandler[0]);
        this.addService("echoHandler", (HttpServiceHandler)new PrefixedEchoHandler(), new HttpServiceHandler[0]);
    }

    public static class AppConfig
    extends Config {
        private final boolean addTimeSchedule;
        private final boolean addSizeSchedule;
        private final String timeScheduleName;
        private final String sizeScheduleName;
        private final String timeScheduleCron;

        public AppConfig() {
            this.addTimeSchedule = true;
            this.addSizeSchedule = true;
            this.timeScheduleName = FakeApp.TIME_SCHEDULE_NAME;
            this.sizeScheduleName = FakeApp.STREAM_SCHEDULE_NAME;
            this.timeScheduleCron = FakeApp.SCHEDULE_CRON;
        }

        public AppConfig(boolean addTimeSchedule, boolean addSizeSchedule, @Nullable String timeScheduleName, @Nullable String sizeScheduleName, String timeScheduleCron) {
            this.addTimeSchedule = addTimeSchedule;
            this.addSizeSchedule = addSizeSchedule;
            this.timeScheduleName = timeScheduleName == null ? FakeApp.TIME_SCHEDULE_NAME : timeScheduleName;
            this.sizeScheduleName = sizeScheduleName == null ? FakeApp.STREAM_SCHEDULE_NAME : sizeScheduleName;
            this.timeScheduleCron = timeScheduleCron == null ? FakeApp.SCHEDULE_CRON : timeScheduleCron;
        }
    }
}

