/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.app;

import co.cask.cdap.api.Config;
import co.cask.cdap.api.annotation.ProcessInput;
import co.cask.cdap.api.annotation.Property;
import co.cask.cdap.api.app.AbstractApplication;
import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.data.stream.Stream;
import co.cask.cdap.api.dataset.lib.KeyValueTable;
import co.cask.cdap.api.flow.AbstractFlow;
import co.cask.cdap.api.flow.Flow;
import co.cask.cdap.api.flow.flowlet.AbstractFlowlet;
import co.cask.cdap.api.flow.flowlet.Flowlet;
import co.cask.cdap.api.flow.flowlet.StreamEvent;
import co.cask.cdap.api.worker.AbstractWorker;
import co.cask.cdap.api.worker.Worker;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigTestApp
extends AbstractApplication<ConfigClass> {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigTestApp.class);
    public static final String NAME = "configtestapp";
    public static final String FLOW_NAME = "simpleFlow";
    public static final String FLOWLET_NAME = "simpleFlowlet";
    public static final String DEFAULT_STREAM = "defaultStream";
    public static final String DEFAULT_TABLE = "defaultTable";

    public void configure() {
        this.setName(NAME);
        ConfigClass configObj = (ConfigClass)this.getConfig();
        this.addStream(new Stream(configObj.streamName));
        this.createDataset(configObj.tableName, KeyValueTable.class);
        this.addWorker((Worker)new DefaultWorker(configObj.streamName));
        this.addFlow((Flow)new SimpleFlow(configObj.streamName, configObj.tableName));
    }

    private static class DefaultWorker
    extends AbstractWorker {
        private final String streamName;
        private volatile boolean stopped;

        DefaultWorker(String streamName) {
            this.streamName = streamName;
        }

        public void run() {
            while (!this.stopped) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted Exception", (Throwable)e);
                }
                try {
                    this.getContext().write(this.streamName, "Hello World");
                }
                catch (IOException e) {
                    LOG.error("IOException while trying to write to stream", (Throwable)e);
                }
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }

    private static class SimpleFlowlet
    extends AbstractFlowlet {
        @Property
        private final String datasetName;

        SimpleFlowlet(String datasetName) {
            this.datasetName = datasetName;
        }

        @ProcessInput
        public void process(StreamEvent event) {
            KeyValueTable dataset = (KeyValueTable)this.getContext().getDataset(this.datasetName);
            String data = Bytes.toString((ByteBuffer)((ByteBuffer)event.getBody()));
            dataset.write(data, data);
        }
    }

    private static class SimpleFlow
    extends AbstractFlow {
        private final String streamName;
        private final String datasetName;

        SimpleFlow(String streamName, String datasetName) {
            this.streamName = streamName;
            this.datasetName = datasetName;
        }

        protected void configure() {
            this.setName(ConfigTestApp.FLOW_NAME);
            this.addFlowlet(ConfigTestApp.FLOWLET_NAME, (Flowlet)new SimpleFlowlet(this.datasetName));
            this.connectStream(this.streamName, ConfigTestApp.FLOWLET_NAME);
        }
    }

    public static class ConfigClass
    extends Config {
        private String streamName;
        private String tableName;

        public ConfigClass() {
            this.streamName = ConfigTestApp.DEFAULT_STREAM;
            this.tableName = ConfigTestApp.DEFAULT_TABLE;
        }

        public ConfigClass(String streamName, String tableName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)streamName) ? 1 : 0) != 0);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tableName) ? 1 : 0) != 0);
            this.streamName = streamName;
            this.tableName = tableName;
        }

        public String getStreamName() {
            return this.streamName;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

