/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.app;

import co.cask.cdap.api.dataset.DatasetAdmin;
import co.cask.cdap.api.dataset.DatasetContext;
import co.cask.cdap.api.dataset.DatasetDefinition;
import co.cask.cdap.api.dataset.DatasetProperties;
import co.cask.cdap.api.dataset.DatasetSpecification;
import co.cask.cdap.api.dataset.lib.AbstractDatasetDefinition;
import co.cask.cdap.api.dataset.lib.KeyValueTable;
import co.cask.cdap.client.app.FakeDataset;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;

public class FakeDatasetDefinition
extends AbstractDatasetDefinition<FakeDataset, DatasetAdmin> {
    private final DatasetDefinition<? extends KeyValueTable, ?> tableDef;

    public FakeDatasetDefinition(String name, DatasetDefinition<? extends KeyValueTable, ?> keyValueDef) {
        super(name);
        Preconditions.checkArgument((keyValueDef != null ? 1 : 0) != 0, (Object)"KeyValueTable definition is required");
        this.tableDef = keyValueDef;
    }

    public DatasetSpecification configure(String instanceName, DatasetProperties properties) {
        return DatasetSpecification.builder((String)instanceName, (String)this.getName()).properties(properties.getProperties()).datasets(new DatasetSpecification[]{this.tableDef.configure("objects", properties)}).build();
    }

    public DatasetAdmin getAdmin(DatasetContext datasetContext, DatasetSpecification spec, ClassLoader classLoader) throws IOException {
        return this.tableDef.getAdmin(datasetContext, spec.getSpecification("objects"), classLoader);
    }

    public FakeDataset getDataset(DatasetContext datasetContext, DatasetSpecification spec, Map<String, String> arguments, ClassLoader classLoader) throws IOException {
        DatasetSpecification kvTableSpec = spec.getSpecification("objects");
        KeyValueTable table = (KeyValueTable)this.tableDef.getDataset(datasetContext, kvTableSpec, arguments, classLoader);
        return new FakeDataset(spec.getName(), table);
    }
}

