/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.app;

import co.cask.cdap.api.workflow.AbstractWorkflowAction;
import co.cask.cdap.api.workflow.Workflow;
import co.cask.cdap.api.workflow.WorkflowAction;
import co.cask.cdap.api.workflow.WorkflowConfigurer;
import co.cask.cdap.api.workflow.WorkflowContext;
import co.cask.cdap.api.workflow.WorkflowToken;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FakeWorkflow
implements Workflow {
    private static final Logger LOG = LoggerFactory.getLogger(FakeWorkflow.class);
    public static final String NAME = "FakeWorkflow";
    public static final String FAKE_LOG = "Running FakeWorkflow";

    public void configure(WorkflowConfigurer configurer) {
        configurer.setName(NAME);
        configurer.addAction((WorkflowAction)new FakeAction());
        configurer.addAction((WorkflowAction)new FakeAction("NotQuiteFakeActionName"));
    }

    public static class FakeAction
    extends AbstractWorkflowAction {
        public static final String TOKEN_KEY = "tokenKey";
        public static final String TOKEN_VALUE = "tokenValue";
        public static final String ANOTHER_FAKE_NAME = "NotQuiteFakeActionName";

        public FakeAction() {
            this(FakeAction.class.getSimpleName());
        }

        public FakeAction(String actionName) {
            super(actionName);
        }

        public void initialize(WorkflowContext context) throws Exception {
            super.initialize(context);
            WorkflowToken token = context.getToken();
            Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"Workflow actions should always have a workflow token available");
            token.put(TOKEN_KEY, TOKEN_VALUE);
        }

        public void run() {
            LOG.info(FakeWorkflow.FAKE_LOG);
            File doneFile = new File((String)this.getContext().getRuntimeArguments().get("done.file"));
            while (!doneFile.exists()) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

