/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.app;

import co.cask.cdap.api.Config;
import co.cask.cdap.api.annotation.ProcessInput;
import co.cask.cdap.api.annotation.Property;
import co.cask.cdap.api.app.AbstractApplication;
import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.dataset.lib.KeyValueTable;
import co.cask.cdap.api.flow.AbstractFlow;
import co.cask.cdap.api.flow.Flow;
import co.cask.cdap.api.flow.flowlet.AbstractFlowlet;
import co.cask.cdap.api.flow.flowlet.Flowlet;
import co.cask.cdap.api.flow.flowlet.FlowletContext;
import co.cask.cdap.api.flow.flowlet.StreamEvent;
import co.cask.cdap.api.service.http.HttpServiceHandler;
import co.cask.cdap.api.worker.AbstractWorker;
import co.cask.cdap.api.worker.Worker;
import co.cask.cdap.client.app.PingService;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class ConfigurableProgramsApp2
extends AbstractApplication<Programs> {
    public void configure() {
        Programs config = (Programs)this.getConfig();
        if (config.flow != null) {
            this.addFlow((Flow)new Floh(config.flow, config.stream, config.dataset));
        }
        if (config.worker != null) {
            this.addWorker((Worker)new Wurker(config.stream));
        }
        if (config.service != null) {
            this.addService(config.service, (HttpServiceHandler)new PingService(), new HttpServiceHandler[0]);
        }
    }

    private static class Wurker
    extends AbstractWorker {
        private final String streamName;
        private volatile boolean running;

        public Wurker(String streamName) {
            this.streamName = streamName;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    this.getContext().write(this.streamName, "Samuel,L. Jackson");
                    this.getContext().write(this.streamName, "Dwayne,Johnson");
                }
                catch (IOException iOException) {}
            }
        }

        public void stop() {
            this.running = false;
        }
    }

    private static class Flohlet
    extends AbstractFlowlet {
        @Property
        private final String datasetName;
        private KeyValueTable keyValueTable;

        public Flohlet(String datasetName) {
            this.datasetName = datasetName;
        }

        @ProcessInput
        public void process(StreamEvent event) {
            String data = Bytes.toString((ByteBuffer)((ByteBuffer)event.getBody()));
            String[] fields = data.split(",");
            this.keyValueTable.write(fields[0], fields[1]);
        }

        public void initialize(FlowletContext context) throws Exception {
            super.initialize(context);
            this.keyValueTable = (KeyValueTable)context.getDataset(this.datasetName);
        }
    }

    private static class Floh
    extends AbstractFlow {
        private final String name;
        private final String stream;
        private final String dataset;

        public Floh(String name, String stream, String dataset) {
            this.name = name;
            this.stream = stream;
            this.dataset = dataset;
        }

        protected void configureFlow() {
            this.setName(this.name);
            this.addFlowlet("flohlet", (Flowlet)new Flohlet(this.dataset));
            this.connectStream(this.stream, "flohlet");
        }
    }

    public static class Programs
    extends Config {
        @Nullable
        private String flow;
        @Nullable
        private String worker;
        @Nullable
        private String stream;
        @Nullable
        private String dataset;
        @Nullable
        private String service;

        public Programs() {
            this.stream = "streem";
            this.dataset = "dutaset";
        }

        public Programs(String flow, String worker, String stream, String dataset, String service) {
            this.flow = flow;
            this.worker = worker;
            this.stream = stream;
            this.dataset = dataset;
            this.service = service;
        }
    }
}

