/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.app;

import co.cask.cdap.api.app.ApplicationConfigurer;
import co.cask.cdap.api.app.ApplicationContext;
import co.cask.cdap.api.mapreduce.AbstractMapReduce;
import co.cask.cdap.api.mapreduce.MapReduce;
import co.cask.cdap.api.schedule.Schedules;
import co.cask.cdap.api.templates.AdapterConfigurer;
import co.cask.cdap.api.templates.ApplicationTemplate;
import co.cask.cdap.api.workflow.AbstractWorkflow;
import co.cask.cdap.api.workflow.Workflow;
import java.util.Map;

public class TemplateApp
extends ApplicationTemplate<Map<String, String>> {
    public static final String NAME = "dummyAdapter";

    public void configure(ApplicationConfigurer configurer, ApplicationContext context) {
        configurer.setName(NAME);
        configurer.setDescription("Application for to test Adapter lifecycle");
        configurer.addWorkflow((Workflow)new AdapterWorkflow());
        configurer.addMapReduce((MapReduce)new DummyMapReduceJob());
    }

    public void configureAdapter(String adapterName, Map<String, String> configuration, AdapterConfigurer configurer) throws Exception {
        configurer.setSchedule(Schedules.createTimeSchedule((String)"schedule", (String)"description", (String)"0/1 * * * *"));
    }

    public static class DummyMapReduceJob
    extends AbstractMapReduce {
        public static final String NAME = "DummyMapReduceJob";

        protected void configure() {
            this.setName(NAME);
            this.setDescription("Mapreduce that does nothing (and actually doesn't run) - it is here to test Adapter lifecycle");
        }
    }

    public static class AdapterWorkflow
    extends AbstractWorkflow {
        protected void configure() {
            this.setName("AdapterWorkflow");
            this.setDescription("Workflow to test Adapter");
            this.addMapReduce("DummyMapReduceJob");
        }
    }
}

