/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.app;

import co.cask.cdap.api.app.AbstractApplication;
import co.cask.cdap.api.data.stream.Stream;
import co.cask.cdap.api.schedule.Schedules;
import co.cask.cdap.api.service.http.HttpServiceHandler;
import co.cask.cdap.api.spark.Spark;
import co.cask.cdap.client.app.FakeDataset;
import co.cask.cdap.client.app.FakeDatasetModule;
import co.cask.cdap.client.app.FakeFlow;
import co.cask.cdap.client.app.FakeSpark;
import co.cask.cdap.client.app.FakeWorkflow;
import co.cask.cdap.client.app.PingService;
import co.cask.cdap.client.app.PrefixedEchoHandler;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;

public class FakeApp
extends AbstractApplication {
    public static final String NAME = "FakeApp";
    public static final String STREAM_NAME = "fakeStream";
    public static final String DS_NAME = "fakeds";
    public static final String SCHEDULE_NAME = "someSchedule";
    public static final String SCHEDULE_CRON = "0 0 1 1 *";
    public static final String STREAM_SCHEDULE_NAME = "streamSchedule";
    public static final int STREAM_TRIGGER_MB = 10000;
    public static final List<String> FLOWS = Lists.newArrayList((Object[])new String[]{"FakeFlow"});
    public static final List<String> MAPREDUCES = Lists.newArrayList();
    public static final List<String> SPARK = Lists.newArrayList((Object[])new String[]{"FakeSparkProgram"});
    public static final List<String> WORKFLOWS = Lists.newArrayList((Object[])new String[]{"FakeWorkflow"});
    public static final List<String> SERVICES = Lists.newArrayList((Object[])new String[]{"pingService", "echoHandler"});
    public static final List<String> ALL_PROGRAMS = ImmutableList.builder().addAll(FLOWS).addAll(MAPREDUCES).addAll(WORKFLOWS).addAll(SPARK).addAll(SERVICES).build();

    public void configure() {
        this.setName(NAME);
        this.addStream(new Stream(STREAM_NAME));
        this.addDatasetModule("fakeDSModule", FakeDatasetModule.class);
        this.createDataset(DS_NAME, FakeDataset.class.getName());
        this.addFlow(new FakeFlow());
        this.addSpark((Spark)new FakeSpark());
        this.addWorkflow(new FakeWorkflow());
        this.scheduleWorkflow(Schedules.createTimeSchedule((String)SCHEDULE_NAME, (String)"", (String)SCHEDULE_CRON), "FakeWorkflow");
        this.scheduleWorkflow(Schedules.createDataSchedule((String)STREAM_SCHEDULE_NAME, (String)"", (Schedules.Source)Schedules.Source.STREAM, (String)STREAM_NAME, (int)10000), "FakeWorkflow");
        this.addService("pingService", (HttpServiceHandler)new PingService(), new HttpServiceHandler[0]);
        this.addService("echoHandler", (HttpServiceHandler)new PrefixedEchoHandler(), new HttpServiceHandler[0]);
    }
}

