/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.app;

import co.cask.cdap.api.app.ApplicationConfigurer;
import co.cask.cdap.api.app.ApplicationContext;
import co.cask.cdap.api.templates.AdapterConfigurer;
import co.cask.cdap.api.templates.ApplicationTemplate;
import co.cask.cdap.api.worker.AbstractWorker;
import co.cask.cdap.api.worker.Worker;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DummyWorkerTemplate
extends ApplicationTemplate<Config> {
    public static final String NAME = "workerTemplate";
    private static final String ADAPTER_NAME = "adapterName";

    public void configure(ApplicationConfigurer configurer, ApplicationContext context) {
        configurer.setName(NAME);
        configurer.addWorker((Worker)new TWorker());
    }

    public void configureAdapter(String adapterName, Config config, AdapterConfigurer configurer) throws Exception {
        configurer.addRuntimeArgument(ADAPTER_NAME, adapterName);
        configurer.setInstances(config.instances);
    }

    public static class TWorker
    extends AbstractWorker {
        private static final Logger LOG = LoggerFactory.getLogger(TWorker.class);
        public static final String NAME = TWorker.class.getSimpleName();
        private volatile boolean running;

        public void configure() {
            this.setName(NAME);
        }

        public void run() {
            this.running = true;
            String adapterName = (String)this.getContext().getRuntimeArguments().get(DummyWorkerTemplate.ADAPTER_NAME);
            int instanceCount = this.getContext().getInstanceCount();
            int instanceId = this.getContext().getInstanceId();
            Preconditions.checkNotNull((Object)adapterName);
            while (this.running) {
                try {
                    LOG.info("Adapter {}; Instance: Count {} Id {}", new Object[]{adapterName, instanceCount, instanceId});
                    TimeUnit.MILLISECONDS.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void stop() {
            this.running = false;
        }
    }

    public static class Config {
        private final int instances;

        public Config(int instances) {
            this.instances = instances;
        }
    }
}

