/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.client.app;

import co.cask.cdap.api.annotation.ProcessInput;
import co.cask.cdap.api.annotation.UseDataSet;
import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.flow.Flow;
import co.cask.cdap.api.flow.FlowSpecification;
import co.cask.cdap.api.flow.flowlet.AbstractFlowlet;
import co.cask.cdap.api.flow.flowlet.Flowlet;
import co.cask.cdap.api.flow.flowlet.InputContext;
import co.cask.cdap.api.flow.flowlet.StreamEvent;
import co.cask.cdap.client.app.FakeDataset;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;

public class FakeFlow
implements Flow {
    public static final String NAME = "FakeFlow";
    public static final String FLOWLET_NAME = "fakeFlowlet";

    public FlowSpecification configure() {
        return FlowSpecification.Builder.with().setName(NAME).setDescription("Does nothing").withFlowlets().add(FLOWLET_NAME, (Flowlet)new FakeFlowlet()).connect().fromStream("fakeStream").to(FLOWLET_NAME).build();
    }

    public static final class FakeFlowlet
    extends AbstractFlowlet {
        @UseDataSet(value="fakeds")
        private FakeDataset fakeDataset;

        @ProcessInput
        public void process(StreamEvent event, InputContext context) throws CharacterCodingException {
            String eventBody = Bytes.toString((ByteBuffer)((ByteBuffer)event.getBody()));
            int separatorIndex = eventBody.indexOf(":");
            if (separatorIndex != -1) {
                this.fakeDataset.put(Bytes.toBytes((String)eventBody.substring(0, separatorIndex)), Bytes.toBytes((String)eventBody.substring(separatorIndex + 1)));
            }
        }
    }
}

