/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.security.authorization;

import co.cask.cdap.api.data.DatasetInstantiationException;
import co.cask.cdap.api.dataset.DatasetDefinition;
import co.cask.cdap.api.dataset.DatasetProperties;
import co.cask.cdap.api.dataset.table.Table;
import co.cask.cdap.data.dataset.SystemDatasetInstantiator;
import co.cask.cdap.data2.datafabric.dataset.DatasetsUtil;
import co.cask.cdap.data2.dataset2.DatasetFramework;
import co.cask.cdap.data2.dataset2.DatasetManagementException;
import co.cask.cdap.data2.dataset2.MultiThreadDatasetCache;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.id.NamespaceId;
import co.cask.cdap.proto.security.Action;
import co.cask.cdap.security.authorization.ACLDataset;
import co.cask.cdap.security.authorization.AuthorizationPlugin;
import co.cask.tephra.TransactionAware;
import co.cask.tephra.TransactionExecutor;
import co.cask.tephra.TransactionExecutorFactory;
import co.cask.tephra.TransactionSystemClient;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DatasetAuthorizationPlugin
implements AuthorizationPlugin {
    private final Supplier<ACLDataset> acls;
    private final Supplier<TransactionExecutor> aclsTx;
    private final MultiThreadDatasetCache dsCache;

    @Inject
    public DatasetAuthorizationPlugin(final DatasetFramework dsFramework, final TransactionExecutorFactory txExecutorFactory, TransactionSystemClient txClient) {
        this.dsCache = new MultiThreadDatasetCache(new SystemDatasetInstantiator(dsFramework, null, null), txClient, new NamespaceId(ACLDataset.ID.getNamespace().getId()), null, null, null);
        this.acls = new Supplier<ACLDataset>(){

            public ACLDataset get() {
                Table table;
                try {
                    table = (Table)DatasetAuthorizationPlugin.this.dsCache.getDataset(ACLDataset.ID.getId());
                }
                catch (DatasetInstantiationException e) {
                    try {
                        table = (Table)DatasetsUtil.getOrCreateDataset((DatasetFramework)dsFramework, (Id.DatasetInstance)ACLDataset.ID, (String)"table", (DatasetProperties)DatasetProperties.EMPTY, (Map)DatasetDefinition.NO_ARGUMENTS, null);
                    }
                    catch (DatasetManagementException | IOException e1) {
                        throw Throwables.propagate((Throwable)e1);
                    }
                }
                return new ACLDataset(table);
            }
        };
        this.aclsTx = new Supplier<TransactionExecutor>(){

            public TransactionExecutor get() {
                return txExecutorFactory.createExecutor((Iterable)ImmutableList.of((Object)((TransactionAware)DatasetAuthorizationPlugin.this.acls.get())));
            }
        };
    }

    public boolean authorized(final EntityId entity, final String user, final Set<Action> actions) {
        return (Boolean)((TransactionExecutor)this.aclsTx.get()).executeUnchecked((TransactionExecutor.Function)new TransactionExecutor.Function<ACLDataset, Boolean>(){

            public Boolean apply(ACLDataset acls) throws Exception {
                HashSet unfulfilledActions = new HashSet(actions);
                for (EntityId current : entity.getHierarchy()) {
                    Set<Action> allowedActions = acls.search(current, user);
                    if (allowedActions.contains(Action.ALL)) {
                        return true;
                    }
                    unfulfilledActions.removeAll(allowedActions);
                    if (!unfulfilledActions.isEmpty()) continue;
                    return true;
                }
                return unfulfilledActions.isEmpty();
            }
        }, this.acls.get());
    }

    public void grant(final EntityId entity, final String user, final Set<Action> actions) {
        ((TransactionExecutor)this.aclsTx.get()).executeUnchecked((TransactionExecutor.Procedure)new TransactionExecutor.Procedure<ACLDataset>(){

            public void apply(ACLDataset acls) throws Exception {
                for (Action action : actions) {
                    acls.add(entity, user, action);
                }
            }
        }, this.acls.get());
    }

    public void grant(final EntityId entity, final String user) {
        ((TransactionExecutor)this.aclsTx.get()).executeUnchecked((TransactionExecutor.Procedure)new TransactionExecutor.Procedure<ACLDataset>(){

            public void apply(ACLDataset acls) throws Exception {
                acls.add(entity, user, Action.ALL);
            }
        }, this.acls.get());
    }

    public void revoke(final EntityId entity, final String user, final Set<Action> actions) {
        ((TransactionExecutor)this.aclsTx.get()).executeUnchecked((TransactionExecutor.Procedure)new TransactionExecutor.Procedure<ACLDataset>(){

            public void apply(ACLDataset acls) throws Exception {
                for (Action action : actions) {
                    acls.remove(entity, user, action);
                }
            }
        }, this.acls.get());
    }

    public void revoke(final EntityId entity, final String user) {
        ((TransactionExecutor)this.aclsTx.get()).executeUnchecked((TransactionExecutor.Procedure)new TransactionExecutor.Procedure<ACLDataset>(){

            public void apply(ACLDataset acls) throws Exception {
                acls.remove(entity, user);
            }
        }, this.acls.get());
    }

    public void revoke(final EntityId entity) {
        ((TransactionExecutor)this.aclsTx.get()).executeUnchecked((TransactionExecutor.Procedure)new TransactionExecutor.Procedure<ACLDataset>(){

            public void apply(ACLDataset acls) throws Exception {
                acls.remove(entity);
            }
        }, this.acls.get());
    }
}

