/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.security.authorization;

import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.dataset.Dataset;
import co.cask.cdap.api.dataset.lib.AbstractDataset;
import co.cask.cdap.api.dataset.table.Row;
import co.cask.cdap.api.dataset.table.Scanner;
import co.cask.cdap.api.dataset.table.Table;
import co.cask.cdap.data2.dataset2.lib.table.MDSKey;
import co.cask.cdap.proto.Id;
import co.cask.cdap.proto.id.EntityId;
import co.cask.cdap.proto.security.Action;
import java.util.HashSet;
import java.util.Set;

class ACLDataset
extends AbstractDataset {
    public static final String NAME = "acls";
    public static final Id.DatasetInstance ID = Id.DatasetInstance.from((Id.Namespace)Id.Namespace.SYSTEM, (String)"acls");
    private static final byte[] VALUE_COLUMN = new byte[0];
    private final Table table;

    ACLDataset(Table table) {
        super(NAME, (Dataset)table, new Dataset[0]);
        this.table = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Action> search(EntityId entity, String user) {
        HashSet<Action> result = new HashSet<Action>();
        MDSKey mdsKey = this.getKey(entity, user);
        byte[] startKey = mdsKey.getKey();
        byte[] stopKey = Bytes.stopKeyForPrefix((byte[])startKey);
        try (Scanner scan = this.table.scan(startKey, stopKey);){
            Row next;
            while ((next = scan.next()) != null) {
                byte[] value = next.get(VALUE_COLUMN);
                if (value == null) continue;
                result.add(Action.valueOf((String)Bytes.toString((byte[])value)));
            }
        }
        return result;
    }

    public void add(EntityId entity, String user, Action action) {
        this.table.put(this.getKey(entity, user, action).getKey(), VALUE_COLUMN, Bytes.toBytes((String)action.name()));
    }

    public void remove(EntityId entity, String user, Action action) {
        this.table.delete(this.getKey(entity, user, action).getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EntityId entity, String user) {
        MDSKey mdsKey = this.getKey(entity, user);
        byte[] startKey = mdsKey.getKey();
        byte[] stopKey = Bytes.stopKeyForPrefix((byte[])startKey);
        try (Scanner scan = this.table.scan(startKey, stopKey);){
            Row next;
            while ((next = scan.next()) != null) {
                this.table.delete(next.getRow());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(EntityId entity) {
        MDSKey mdsKey = this.getKey(entity);
        byte[] startKey = mdsKey.getKey();
        byte[] stopKey = Bytes.stopKeyForPrefix((byte[])startKey);
        try (Scanner scan = this.table.scan(startKey, stopKey);){
            Row next;
            while ((next = scan.next()) != null) {
                this.table.delete(next.getRow());
            }
        }
    }

    private MDSKey getKey(EntityId entity) {
        MDSKey.Builder builder = new MDSKey.Builder();
        builder.add(entity.toString());
        return builder.build();
    }

    private MDSKey getKey(EntityId entity, String user) {
        MDSKey.Builder builder = new MDSKey.Builder();
        builder.add(entity.toString());
        builder.add(user);
        return builder.build();
    }

    private MDSKey getKey(EntityId entity, String user, Action action) {
        MDSKey.Builder builder = new MDSKey.Builder();
        builder.add(entity.toString());
        builder.add(user);
        builder.add(action.name());
        return builder.build();
    }
}

