/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.internal.io;

import co.cask.cdap.api.data.schema.Schema;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SchemaTypeAdapter
extends TypeAdapter<Schema> {
    public void write(JsonWriter writer, Schema schema) throws IOException {
        if (schema == null) {
            writer.nullValue();
            return;
        }
        HashSet<String> knownRecords = new HashSet<String>();
        this.write(writer, schema, knownRecords);
    }

    public Schema read(JsonReader reader) throws IOException {
        return this.read(reader, new HashMap<String, Schema>());
    }

    private Schema read(JsonReader reader, Map<String, Schema> knownRecords) throws IOException {
        JsonToken token = reader.peek();
        switch (token) {
            case NULL: {
                return null;
            }
            case STRING: {
                String name = reader.nextString();
                if (knownRecords.containsKey(name)) {
                    Schema schema = knownRecords.get(name);
                    return schema == null ? Schema.recordOf(name) : schema;
                }
                return Schema.of(Schema.Type.valueOf(name.toUpperCase()));
            }
            case BEGIN_ARRAY: {
                return this.readUnion(reader, knownRecords);
            }
            case BEGIN_OBJECT: {
                Schema schema;
                reader.beginObject();
                String name = reader.nextName();
                if (!"type".equals(name)) {
                    throw new IOException("Property \"type\" missing.");
                }
                Schema.Type schemaType = Schema.Type.valueOf(reader.nextString().toUpperCase());
                switch (schemaType) {
                    case ENUM: {
                        schema = this.readEnum(reader);
                        break;
                    }
                    case ARRAY: {
                        schema = this.readArray(reader, knownRecords);
                        break;
                    }
                    case MAP: {
                        schema = this.readMap(reader, knownRecords);
                        break;
                    }
                    case RECORD: {
                        schema = this.readRecord(reader, knownRecords);
                        break;
                    }
                    default: {
                        schema = Schema.of(schemaType);
                    }
                }
                reader.endObject();
                return schema;
            }
        }
        throw new IOException("Malformed schema input.");
    }

    private Schema readUnion(JsonReader reader, Map<String, Schema> knownRecords) throws IOException {
        ArrayList<Schema> unionSchemas = new ArrayList<Schema>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            unionSchemas.add(this.read(reader, knownRecords));
        }
        reader.endArray();
        return Schema.unionOf(unionSchemas);
    }

    private Schema readEnum(JsonReader reader) throws IOException {
        if (!"symbols".equals(reader.nextName())) {
            throw new IOException("Property \"symbols\" missing for enum.");
        }
        ArrayList<String> enumValues = new ArrayList<String>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            enumValues.add(reader.nextString());
        }
        reader.endArray();
        return Schema.enumWith(enumValues);
    }

    private Schema readArray(JsonReader reader, Map<String, Schema> knownRecords) throws IOException {
        return Schema.arrayOf(this.readInnerSchema(reader, "items", knownRecords));
    }

    private Schema readMap(JsonReader reader, Map<String, Schema> knownRecords) throws IOException {
        return Schema.mapOf(this.readInnerSchema(reader, "keys", knownRecords), this.readInnerSchema(reader, "values", knownRecords));
    }

    private Schema readRecord(JsonReader reader, Map<String, Schema> knownRecords) throws IOException {
        if (!"name".equals(reader.nextName())) {
            throw new IOException("Property \"name\" missing for record.");
        }
        String recordName = reader.nextString();
        if (!"fields".equals(reader.nextName())) {
            throw new IOException("Property \"fields\" missing for record.");
        }
        knownRecords.put(recordName, null);
        ArrayList<Schema.Field> fieldBuilder = new ArrayList<Schema.Field>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            reader.beginObject();
            if (!"name".equals(reader.nextName())) {
                throw new IOException("Property \"name\" missing for record field.");
            }
            String fieldName = reader.nextString();
            fieldBuilder.add(Schema.Field.of(fieldName, this.readInnerSchema(reader, "type", knownRecords)));
            reader.endObject();
        }
        reader.endArray();
        Schema schema = Schema.recordOf(recordName, fieldBuilder);
        knownRecords.put(recordName, schema);
        return schema;
    }

    private Schema readInnerSchema(JsonReader reader, String key, Map<String, Schema> knownRecords) throws IOException {
        if (!key.equals(reader.nextName())) {
            throw new IOException("Property \"" + key + "\" missing.");
        }
        return this.read(reader, knownRecords);
    }

    private JsonWriter write(JsonWriter writer, Schema schema, Set<String> knownRecords) throws IOException {
        if (schema.getType().isSimpleType()) {
            return writer.value(schema.getType().name().toLowerCase());
        }
        if (schema.getType() == Schema.Type.UNION) {
            writer.beginArray();
            for (Schema unionSchema : schema.getUnionSchemas()) {
                this.write(writer, unionSchema, knownRecords);
            }
            return writer.endArray();
        }
        if (schema.getType() == Schema.Type.RECORD && knownRecords.contains(schema.getRecordName())) {
            return writer.value(schema.getRecordName());
        }
        writer.beginObject().name("type").value(schema.getType().name().toLowerCase());
        switch (schema.getType()) {
            case ENUM: {
                writer.name("symbols").beginArray();
                for (String enumValue : schema.getEnumValues()) {
                    writer.value(enumValue);
                }
                writer.endArray();
                break;
            }
            case ARRAY: {
                this.write(writer.name("items"), schema.getComponentSchema(), knownRecords);
                break;
            }
            case MAP: {
                Map.Entry<Schema, Schema> mapSchema = schema.getMapSchema();
                this.write(writer.name("keys"), mapSchema.getKey(), knownRecords);
                this.write(writer.name("values"), mapSchema.getValue(), knownRecords);
                break;
            }
            case RECORD: {
                knownRecords.add(schema.getRecordName());
                writer.name("name").value(schema.getRecordName()).name("fields").beginArray();
                for (Schema.Field field : schema.getFields()) {
                    writer.beginObject().name("name").value(field.getName());
                    this.write(writer.name("type"), field.getSchema(), knownRecords);
                    writer.endObject();
                }
                writer.endArray();
            }
        }
        writer.endObject();
        return writer;
    }
}

