/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.api.data.format;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.common.Bytes;
import co.cask.cdap.api.data.format.UnexpectedFormatException;
import co.cask.cdap.api.data.schema.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Beta
public class StructuredRecord {
    private final Schema schema;
    private final Map<String, Object> fields;

    private StructuredRecord(Schema schema, Map<String, Object> fields) {
        this.schema = schema;
        this.fields = fields;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public <T> T get(String fieldName) {
        return (T)this.fields.get(fieldName);
    }

    public static Builder builder(Schema schema) throws UnexpectedFormatException {
        if (schema == null || schema.getType() != Schema.Type.RECORD || schema.getFields().size() < 1) {
            throw new UnexpectedFormatException("Schema must be a record with at least one field.");
        }
        return new Builder(schema);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StructuredRecord that = (StructuredRecord)o;
        return Objects.equals(this.schema, that.schema) && Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.schema, this.fields);
    }

    public static class Builder {
        private final Schema schema;
        private Map<String, Object> fields;

        private Builder(Schema schema) {
            this.schema = schema;
            this.fields = new HashMap<String, Object>();
        }

        public Builder set(String fieldName, Object value) {
            this.validateAndGetField(fieldName, value);
            this.fields.put(fieldName, value);
            return this;
        }

        public Builder convertAndSet(String fieldName, String strVal) throws UnexpectedFormatException {
            Schema.Field field = this.validateAndGetField(fieldName, strVal);
            this.fields.put(fieldName, this.convertString(field.getSchema(), strVal));
            return this;
        }

        public StructuredRecord build() throws UnexpectedFormatException {
            for (Schema.Field field : this.schema.getFields()) {
                String fieldName = field.getName();
                if (this.fields.containsKey(fieldName)) continue;
                if (!field.getSchema().isNullable()) {
                    throw new UnexpectedFormatException("Field " + fieldName + " must contain a value.");
                }
                this.fields.put(fieldName, null);
            }
            return new StructuredRecord(this.schema, this.fields);
        }

        private Object convertString(Schema schema, String strVal) throws UnexpectedFormatException {
            Schema.Type simpleType;
            if (schema.getType().isSimpleType()) {
                simpleType = schema.getType();
                if (strVal == null && simpleType != Schema.Type.NULL) {
                    throw new UnexpectedFormatException("Cannot set non-nullable field to a null value.");
                }
            } else if (schema.isNullable()) {
                if (strVal == null) {
                    return null;
                }
                simpleType = schema.getNonNullable().getType();
            } else {
                throw new UnexpectedFormatException("Cannot convert a string to schema " + schema);
            }
            switch (simpleType) {
                case BOOLEAN: {
                    return Boolean.parseBoolean(strVal);
                }
                case INT: {
                    return Integer.parseInt(strVal);
                }
                case LONG: {
                    return Long.parseLong(strVal);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(strVal));
                }
                case DOUBLE: {
                    return Double.parseDouble(strVal);
                }
                case BYTES: {
                    return Bytes.toBytesBinary(strVal);
                }
                case STRING: {
                    return strVal;
                }
                case NULL: {
                    return null;
                }
            }
            throw new UnexpectedFormatException("Cannot convert a string to schema " + schema);
        }

        private Schema.Field validateAndGetField(String fieldName, Object val) {
            Schema.Field field = this.schema.getField(fieldName);
            if (field == null) {
                throw new UnexpectedFormatException("field " + fieldName + " is not in the schema.");
            }
            if (!field.getSchema().isNullable() && val == null) {
                throw new UnexpectedFormatException("field " + fieldName + " cannot be set to a null value.");
            }
            return field;
        }
    }
}

