/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.api.data.format;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.data.format.FormatSpecification;
import co.cask.cdap.api.data.format.UnexpectedFormatException;
import co.cask.cdap.api.data.schema.Schema;
import co.cask.cdap.api.data.schema.UnsupportedTypeException;
import java.util.Collections;
import java.util.Map;

@Beta
public abstract class RecordFormat<FROM, TO> {
    protected Schema schema;

    public abstract TO read(FROM var1) throws UnexpectedFormatException;

    protected abstract Schema getDefaultSchema();

    protected abstract void validateSchema(Schema var1) throws UnsupportedTypeException;

    public void initialize(FormatSpecification formatSpecification) throws UnsupportedTypeException {
        Schema desiredSchema = null;
        Map<String, String> settings = Collections.emptyMap();
        if (formatSpecification != null) {
            desiredSchema = formatSpecification.getSchema();
            settings = formatSpecification.getSettings();
        }
        Schema schema = desiredSchema = desiredSchema == null ? this.getDefaultSchema() : desiredSchema;
        if (desiredSchema == null) {
            throw new UnsupportedTypeException("A schema must be provided to this format.");
        }
        this.validateIsRecord(desiredSchema);
        this.validateSchema(desiredSchema);
        this.schema = desiredSchema;
        this.configure(settings);
    }

    protected void configure(Map<String, String> settings) {
    }

    public Schema getSchema() {
        return this.schema;
    }

    private void validateIsRecord(Schema schema) throws UnsupportedTypeException {
        if (schema.getType() != Schema.Type.RECORD || schema.getFields().size() < 1) {
            throw new UnsupportedTypeException("Schema must be a record with at least one field.");
        }
    }
}

