/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.internal.io;

import co.cask.cdap.api.data.schema.Schema;
import java.io.IOException;
import java.util.ArrayList;

public final class SQLSchemaParser {
    private String schema;
    private int pos;
    private int end;
    private int recordNum;

    public SQLSchemaParser(String schema) {
        this.schema = schema.trim().toLowerCase();
        this.pos = 0;
        this.end = this.schema.length();
        this.recordNum = 1;
    }

    public Schema parse() throws IOException {
        try {
            ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
            while (this.pos < this.end) {
                String name = this.nextToken();
                this.expectWhitespace("Expecting whitespace between column name and type");
                this.skipWhitespace();
                this.errorIf(this.pos >= this.end, "Unexpected EOF");
                fields.add(Schema.Field.of(name, this.parseType()));
                if (this.pos >= this.end) break;
                this.advancePastComma("Expected a comma separating schema columns");
            }
            return Schema.recordOf("rec", fields);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
    }

    private Schema parseType() throws IOException {
        Schema type;
        String typeStr = this.nextToken();
        if ("boolean".equals(typeStr)) {
            type = Schema.of(Schema.Type.BOOLEAN);
        } else if ("int".equals(typeStr)) {
            type = Schema.of(Schema.Type.INT);
        } else if ("long".equals(typeStr)) {
            type = Schema.of(Schema.Type.LONG);
        } else if ("float".equals(typeStr)) {
            type = Schema.of(Schema.Type.FLOAT);
        } else if ("double".equals(typeStr)) {
            type = Schema.of(Schema.Type.DOUBLE);
        } else if ("bytes".equals(typeStr)) {
            type = Schema.of(Schema.Type.BYTES);
        } else if ("string".equals(typeStr)) {
            type = Schema.of(Schema.Type.STRING);
        } else if ("null".equals(typeStr)) {
            type = Schema.of(Schema.Type.NULL);
        } else if ("array".equals(typeStr)) {
            type = this.parseArray();
        } else if ("map".equals(typeStr)) {
            type = this.parseMap();
        } else if ("record".equals(typeStr)) {
            type = this.parseRecord();
        } else if ("union".equals(typeStr)) {
            type = this.parseUnion();
        } else {
            throw new IOException("Unknown data type " + typeStr);
        }
        this.skipWhitespace();
        if (this.schema.startsWith("not null", this.pos)) {
            this.pos += 8;
            return type;
        }
        return Schema.nullableOf(type);
    }

    private Schema parseRecord() throws IOException {
        this.expectChar('<', "record must be followed with a '<'");
        this.skipWhitespace();
        String recordName = "rec" + this.recordNum;
        ++this.recordNum;
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        while (true) {
            String colName = this.nextToken();
            this.errorIf(this.schema.charAt(this.pos) != ':', "Expecting a ':' between field name and type");
            ++this.pos;
            this.errorIf(this.pos >= this.end, "Unexpected EOF");
            fields.add(Schema.Field.of(colName, this.parseType()));
            if (this.tryAdvancePastEndBracket()) break;
            this.advancePastComma("Expected a comma separating record fields");
        }
        return Schema.recordOf(recordName, fields);
    }

    private Schema parseMap() throws IOException {
        this.expectChar('<', "map must be followed by a '<'");
        this.skipWhitespace();
        Schema keyType = this.parseType();
        this.advancePastComma("Expected a comma separating map key and value types");
        Schema valueType = this.parseType();
        this.skipWhitespace();
        this.expectChar('>', "map must end with a '>'");
        return Schema.mapOf(keyType, valueType);
    }

    private Schema parseUnion() throws IOException {
        this.expectChar('<', "union must be followed by a '<'");
        this.skipWhitespace();
        ArrayList<Schema> unionTypes = new ArrayList<Schema>();
        while (true) {
            unionTypes.add(this.parseType());
            if (this.tryAdvancePastEndBracket()) break;
            this.advancePastComma("Expected a comma separating union types");
        }
        return Schema.unionOf(unionTypes);
    }

    private Schema parseArray() throws IOException {
        this.expectChar('<', "array must be followed by a '<'");
        this.skipWhitespace();
        Schema componentType = this.parseType();
        this.skipWhitespace();
        this.expectChar('>', "array must end with a '>'");
        return Schema.arrayOf(componentType);
    }

    private boolean tryAdvancePastEndBracket() {
        this.skipWhitespace();
        if (this.schema.charAt(this.pos) == '>') {
            ++this.pos;
            return true;
        }
        return false;
    }

    private void skipWhitespace() {
        while (this.pos < this.end && Character.isWhitespace(this.schema.charAt(this.pos))) {
            ++this.pos;
        }
    }

    private String nextToken() {
        char currChar = this.schema.charAt(this.pos);
        int endPos = this.pos;
        while (!Character.isWhitespace(currChar) && currChar != ':' && currChar != ',' && currChar != '<' && currChar != '>' && ++endPos != this.end) {
            currChar = this.schema.charAt(endPos);
        }
        String token = this.schema.substring(this.pos, endPos);
        this.pos = endPos;
        return token;
    }

    private void advancePastComma(String errMsg) throws IOException {
        this.skipWhitespace();
        this.expectChar(',', errMsg);
        this.skipWhitespace();
    }

    private void expectChar(char c, String errMsg) throws IOException {
        this.errorIf(this.schema.charAt(this.pos) != c, errMsg);
        ++this.pos;
    }

    private void expectWhitespace(String errMsg) throws IOException {
        this.errorIf(!Character.isWhitespace(this.schema.charAt(this.pos)), errMsg);
        this.skipWhitespace();
    }

    private void errorIf(boolean condition, String errMsg) throws IOException {
        if (condition) {
            throw new IOException(String.format("schema is malformed. %s.", errMsg));
        }
    }
}

