/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.api.flow.flowlet;

import co.cask.cdap.api.stream.StreamEventData;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

@Nonnull
public class StreamEvent
extends StreamEventData {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.wrap(new byte[0]);
    private final long timestamp;

    public StreamEvent() {
        this(Collections.emptyMap(), EMPTY_BUFFER);
    }

    public StreamEvent(ByteBuffer body) {
        this(Collections.emptyMap(), body);
    }

    public StreamEvent(Map<String, String> headers, ByteBuffer body) {
        this(headers, body, System.currentTimeMillis());
    }

    public StreamEvent(StreamEventData data, long timestamp) {
        this(data.getHeaders(), (ByteBuffer)data.getBody(), timestamp);
    }

    public StreamEvent(StreamEvent event) {
        this(event.getHeaders(), (ByteBuffer)event.getBody(), event.getTimestamp());
    }

    public StreamEvent(Map<String, String> headers, ByteBuffer body, long timestamp) {
        super(headers, body);
        this.timestamp = timestamp;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

