/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.api.data.schema;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.data.schema.SchemaHash;
import co.cask.cdap.internal.io.SQLSchemaParser;
import co.cask.cdap.internal.io.SchemaTypeAdapter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Multimap;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Beta
public final class Schema {
    private static final SchemaTypeAdapter SCHEMA_TYPE_ADAPTER = new SchemaTypeAdapter();
    private final Type type;
    private final BiMap<String, Integer> enumValues;
    private final BiMap<Integer, String> enumIndexes;
    private final Schema componentSchema;
    private final Schema keySchema;
    private final Schema valueSchema;
    private final Map.Entry<Schema, Schema> mapSchema;
    private final String recordName;
    private final Map<String, Field> fieldMap;
    private final List<Field> fields;
    private final List<Schema> unionSchemas;
    private String schemaString;
    private SchemaHash schemaHash;

    public static Schema parseJson(String schemaJson) throws IOException {
        return (Schema)SCHEMA_TYPE_ADAPTER.fromJson(schemaJson);
    }

    public static Schema parseJson(Reader reader) throws IOException {
        return (Schema)SCHEMA_TYPE_ADAPTER.fromJson(reader);
    }

    public static Schema parseSQL(String schemaString) throws IOException {
        return new SQLSchemaParser(schemaString).parse();
    }

    public static Schema of(Type type) {
        if (!type.isSimpleType()) {
            throw new IllegalArgumentException("Type " + (Object)((Object)type) + " is not a simple type.");
        }
        return new Schema(type, null, null, null, null, null, null, null);
    }

    public static Schema nullableOf(Schema schema) {
        if (schema.type == Type.NULL) {
            throw new IllegalArgumentException("Given schema must not be the null type.");
        }
        return Schema.unionOf(schema, Schema.of(Type.NULL));
    }

    public static Schema enumWith(String ... values) {
        return Schema.enumWith(Arrays.asList(values));
    }

    public static Schema enumWith(Iterable<String> values) {
        LinkedHashSet<String> uniqueValues = new LinkedHashSet<String>();
        for (String value : values) {
            if (uniqueValues.add(value)) continue;
            throw new IllegalArgumentException("Duplicate enum value is not allowed.");
        }
        if (uniqueValues.isEmpty()) {
            throw new IllegalArgumentException("No enum value provided.");
        }
        return new Schema(Type.ENUM, uniqueValues, null, null, null, null, null, null);
    }

    public static Schema enumWith(Class<Enum<?>> enumClass) {
        Enum<?>[] enumConstants = enumClass.getEnumConstants();
        String[] names = new String[enumConstants.length];
        for (int i = 0; i < enumConstants.length; ++i) {
            names[i] = enumConstants[i].name();
        }
        return Schema.enumWith(names);
    }

    public static Schema arrayOf(Schema componentSchema) {
        return new Schema(Type.ARRAY, null, componentSchema, null, null, null, null, null);
    }

    public static Schema mapOf(Schema keySchema, Schema valueSchema) {
        return new Schema(Type.MAP, null, null, keySchema, valueSchema, null, null, null);
    }

    public static Schema recordOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Record name cannot be null.");
        }
        return new Schema(Type.RECORD, null, null, null, null, name, null, null);
    }

    public static Schema recordOf(String name, Field ... fields) {
        return Schema.recordOf(name, Arrays.asList(fields));
    }

    public static Schema recordOf(String name, Iterable<Field> fields) {
        if (name == null) {
            throw new IllegalArgumentException("Record name cannot be null.");
        }
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        for (Field field : fields) {
            fieldMap.put(field.getName(), field);
        }
        if (fieldMap.isEmpty()) {
            throw new IllegalArgumentException("No record field provided for " + name);
        }
        return new Schema(Type.RECORD, null, null, null, null, name, fieldMap, null);
    }

    public static Schema unionOf(Schema ... schemas) {
        return Schema.unionOf(Arrays.asList(schemas));
    }

    public static Schema unionOf(Iterable<Schema> schemas) {
        ArrayList<Schema> schemaList = new ArrayList<Schema>();
        for (Schema schema : schemas) {
            schemaList.add(schema);
        }
        if (schemaList.isEmpty()) {
            throw new IllegalArgumentException("No union schema provided.");
        }
        return new Schema(Type.UNION, null, null, null, null, null, null, schemaList);
    }

    private Schema(Type type, Set<String> enumValues, Schema componentSchema, Schema keySchema, Schema valueSchema, String recordName, Map<String, Field> fieldMap, List<Schema> unionSchemas) {
        this.type = type;
        this.enumValues = this.createIndex(enumValues);
        this.enumIndexes = this.enumValues == null ? null : this.enumValues.inverse();
        this.componentSchema = componentSchema;
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.mapSchema = keySchema == null || valueSchema == null ? null : this.immutableEntry(keySchema, valueSchema);
        this.recordName = recordName;
        this.fieldMap = this.populateRecordFields(fieldMap);
        this.fields = this.fieldMap == null ? null : Collections.unmodifiableList(new ArrayList<Field>(this.fieldMap.values()));
        this.unionSchemas = Collections.unmodifiableList(unionSchemas == null ? new ArrayList() : new ArrayList<Schema>(unionSchemas));
    }

    public Type getType() {
        return this.type;
    }

    public Set<String> getEnumValues() {
        return this.enumValues.keySet();
    }

    public int getEnumIndex(String value) {
        if (this.enumValues == null) {
            return -1;
        }
        Integer idx = (Integer)this.enumValues.get((Object)value);
        return idx == null ? -1 : idx;
    }

    public String getEnumValue(int idx) {
        if (this.enumIndexes == null) {
            return null;
        }
        return (String)this.enumIndexes.get((Object)idx);
    }

    public Schema getComponentSchema() {
        return this.componentSchema;
    }

    public Map.Entry<Schema, Schema> getMapSchema() {
        return this.mapSchema;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Field getField(String name) {
        if (this.fieldMap == null) {
            return null;
        }
        return this.fieldMap.get(name);
    }

    public List<Schema> getUnionSchemas() {
        return this.unionSchemas;
    }

    public Schema getUnionSchema(int idx) {
        return this.unionSchemas == null || idx < 0 || this.unionSchemas.size() <= idx ? null : this.unionSchemas.get(idx);
    }

    public String toString() {
        String str = this.schemaString;
        if (str == null) {
            this.schemaString = str = this.buildString();
        }
        return str;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.getSchemaHash().equals(((Schema)other).getSchemaHash());
    }

    public int hashCode() {
        return this.getSchemaHash().hashCode();
    }

    public SchemaHash getSchemaHash() {
        SchemaHash hash = this.schemaHash;
        if (hash == null) {
            this.schemaHash = hash = new SchemaHash(this);
        }
        return hash;
    }

    public boolean isCompatible(Schema target) {
        if (this.equals(target)) {
            return true;
        }
        HashMultimap recordCompared = HashMultimap.create();
        return this.checkCompatible(target, (Multimap<String, String>)recordCompared);
    }

    public boolean isNullable() {
        if (this.type == Type.UNION && this.unionSchemas.size() == 2) {
            Type type1 = this.unionSchemas.get(0).getType();
            Type type2 = this.unionSchemas.get(1).getType();
            return type1 == Type.NULL && type2 != Type.NULL || type1 != Type.NULL && type2 == Type.NULL;
        }
        return false;
    }

    public boolean isNullableSimple() {
        if (this.type == Type.UNION && this.unionSchemas.size() == 2) {
            Type type1 = this.unionSchemas.get(0).getType();
            Type type2 = this.unionSchemas.get(1).getType();
            if (type1 == Type.NULL) {
                return type2 != Type.NULL && type2.isSimpleType();
            }
            if (type2 == Type.NULL) {
                return type1.isSimpleType();
            }
        }
        return false;
    }

    public boolean isSimpleOrNullableSimple() {
        return this.type.isSimpleType() || this.isNullableSimple();
    }

    public Schema getNonNullable() {
        Schema firstSchema = this.unionSchemas.get(0);
        return firstSchema.getType() == Type.NULL ? this.unionSchemas.get(1) : firstSchema;
    }

    private <K, V> Map.Entry<K, V> immutableEntry(final K key, final V value) {
        return new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return key;
            }

            @Override
            public V getValue() {
                return value;
            }

            @Override
            public V setValue(V value2) {
                throw new UnsupportedOperationException("Mutation to entry not supported");
            }

            public String toString() {
                return this.getKey() + "=" + this.getValue();
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry other = (Map.Entry)obj;
                return Objects.equals(key, other.getKey()) && Objects.equals(value, other.getValue());
            }

            @Override
            public int hashCode() {
                return Objects.hash(this.getKey(), this.getValue());
            }
        };
    }

    private boolean checkCompatible(Schema target, Multimap<String, String> recordCompared) {
        if (this.type.isSimpleType()) {
            if (this.type == target.getType()) {
                return true;
            }
            switch (target.getType()) {
                case LONG: {
                    return this.type == Type.INT;
                }
                case FLOAT: {
                    return this.type == Type.INT || this.type == Type.LONG;
                }
                case DOUBLE: {
                    return this.type == Type.INT || this.type == Type.LONG || this.type == Type.FLOAT;
                }
                case STRING: {
                    return this.type != Type.NULL && this.type != Type.BYTES;
                }
                case UNION: {
                    for (Schema targetSchema : target.unionSchemas) {
                        if (!this.checkCompatible(targetSchema, recordCompared)) continue;
                        return true;
                    }
                    break;
                }
            }
            return false;
        }
        if (this.type == target.type) {
            switch (this.type) {
                case ENUM: {
                    return target.getEnumValues().containsAll(this.getEnumValues());
                }
                case ARRAY: {
                    return this.componentSchema.checkCompatible(target.getComponentSchema(), recordCompared);
                }
                case MAP: {
                    return this.keySchema.checkCompatible(target.keySchema, recordCompared) && this.valueSchema.checkCompatible(target.valueSchema, recordCompared);
                }
                case RECORD: {
                    if (!recordCompared.containsEntry((Object)this.recordName, (Object)target.recordName)) {
                        recordCompared.put((Object)this.recordName, (Object)target.recordName);
                        for (Field field : this.fields) {
                            Field targetField = target.getField(field.getName());
                            if (targetField == null || field.getSchema().checkCompatible(targetField.getSchema(), recordCompared)) continue;
                            return false;
                        }
                    }
                    return true;
                }
                case UNION: {
                    for (Schema sourceSchema : this.unionSchemas) {
                        for (Schema targetSchema : target.unionSchemas) {
                            if (!sourceSchema.checkCompatible(targetSchema, recordCompared)) continue;
                            return true;
                        }
                    }
                    return false;
                }
            }
        }
        if (this.type == Type.UNION || target.type == Type.UNION) {
            List<Schema> unions = this.type == Type.UNION ? this.unionSchemas : target.unionSchemas;
            Schema checkSchema = this.type == Type.UNION ? target : this;
            for (Schema schema : unions) {
                if (!schema.checkCompatible(checkSchema, recordCompared)) continue;
                return true;
            }
        }
        return false;
    }

    private <V> BiMap<V, Integer> createIndex(Set<V> values) {
        if (values == null) {
            return null;
        }
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        int idx = 0;
        for (V value : values) {
            builder.put(value, (Object)idx++);
        }
        return builder.build();
    }

    private Map<String, Field> populateRecordFields(Map<String, Field> fields) {
        if (fields == null) {
            return null;
        }
        HashMap<String, Schema> knownRecordSchemas = new HashMap<String, Schema>();
        knownRecordSchemas.put(this.recordName, this);
        LinkedHashMap<String, Field> resolvedFields = new LinkedHashMap<String, Field>();
        for (Map.Entry<String, Field> fieldEntry : fields.entrySet()) {
            String fieldName = fieldEntry.getKey();
            Field field = fieldEntry.getValue();
            Schema fieldSchema = this.resolveSchema(field.getSchema(), knownRecordSchemas);
            if (fieldSchema == field.getSchema()) {
                resolvedFields.put(fieldName, field);
                continue;
            }
            resolvedFields.put(fieldName, Field.of(fieldName, fieldSchema));
        }
        return Collections.unmodifiableMap(resolvedFields);
    }

    private Schema resolveSchema(Schema schema, Map<String, Schema> knownRecordSchemas) {
        switch (schema.getType()) {
            case ARRAY: {
                Schema componentSchema = this.resolveSchema(schema.getComponentSchema(), knownRecordSchemas);
                return componentSchema == schema.getComponentSchema() ? schema : Schema.arrayOf(componentSchema);
            }
            case MAP: {
                Map.Entry<Schema, Schema> entry = schema.getMapSchema();
                Schema keySchema = this.resolveSchema(entry.getKey(), knownRecordSchemas);
                Schema valueSchema = this.resolveSchema(entry.getValue(), knownRecordSchemas);
                return keySchema == entry.getKey() && valueSchema == entry.getValue() ? schema : Schema.mapOf(keySchema, valueSchema);
            }
            case UNION: {
                ArrayList<Schema> schemas = new ArrayList<Schema>();
                boolean changed = false;
                for (Schema input : schema.getUnionSchemas()) {
                    Schema output = this.resolveSchema(input, knownRecordSchemas);
                    if (output != input) {
                        changed = true;
                    }
                    schemas.add(output);
                }
                return changed ? Schema.unionOf(schemas) : schema;
            }
            case RECORD: {
                if (schema.fields == null) {
                    Schema knownSchema = knownRecordSchemas.get(schema.recordName);
                    if (knownSchema == null) {
                        throw new IllegalArgumentException("Undefined schema " + schema.recordName);
                    }
                    return knownSchema;
                }
                knownRecordSchemas.put(schema.recordName, schema);
                return schema;
            }
        }
        return schema;
    }

    private String buildString() {
        if (this.type.isSimpleType()) {
            return '\"' + this.type.name().toLowerCase() + '\"';
        }
        StringWriter writer = new StringWriter();
        try (JsonWriter jsonWriter = new JsonWriter((Writer)writer);){
            SCHEMA_TYPE_ADAPTER.write(jsonWriter, this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }

    public static final class Field {
        private final String name;
        private final Schema schema;

        public static Field of(String name, Schema schema) {
            return new Field(name, schema);
        }

        private Field(String name, Schema schema) {
            this.name = name;
            this.schema = schema;
        }

        public String getName() {
            return this.name;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public String toString() {
            return String.format("{name: %s, schema: %s}", this.name, this.schema);
        }
    }

    public static enum Type {
        NULL(true),
        BOOLEAN(true),
        INT(true),
        LONG(true),
        FLOAT(true),
        DOUBLE(true),
        BYTES(true),
        STRING(true),
        ENUM(false),
        ARRAY(false),
        MAP(false),
        RECORD(false),
        UNION(false);

        private final boolean simpleType;

        private Type(boolean primitive) {
            this.simpleType = primitive;
        }

        public boolean isSimpleType() {
            return this.simpleType;
        }
    }
}

