/*
 * Decompiled with CFR 0.152.
 */
package co.cask.cdap.api.data.format;

import co.cask.cdap.api.annotation.Beta;
import co.cask.cdap.api.data.schema.Schema;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@Beta
public final class FormatSpecification {
    private final String name;
    private final Schema schema;
    private final Map<String, String> settings;

    private FormatSpecification() {
        this(null, null, Collections.emptyMap());
    }

    public FormatSpecification(String name, @Nullable Schema schema, @Nullable Map<String, String> settings) {
        this.name = name;
        this.schema = schema;
        this.settings = settings == null ? Collections.emptyMap() : settings;
    }

    public FormatSpecification(String name, @Nullable Schema schema) {
        this(name, schema, Collections.emptyMap());
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Schema getSchema() {
        return this.schema;
    }

    public Map<String, String> getSettings() {
        return this.settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FormatSpecification)) {
            return false;
        }
        FormatSpecification that = (FormatSpecification)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.schema, that.schema) && Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.schema, this.settings);
    }

    public String toString() {
        return "FormatSpecification{name='" + this.name + '\'' + ", schema=" + this.schema + ", settings=" + this.settings + '}';
    }
}

