/*
 * Decompiled with CFR 0.152.
 */
package co.cask;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

@Mojo(name="create-plugin-json")
public class PluginJSON
extends AbstractMojo {
    @Parameter(alias="cdap-artifacts", required=true)
    private String[] cdapArtifacts;
    @Parameter(defaultValue="docs")
    private String docsDirectory;
    @Parameter(defaultValue="widgets")
    private String widgetsDirectory;
    @Parameter(defaultValue="icons")
    private String iconsDirectory;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    private File baseDirectory;
    private File widgetDirectory;
    private File iconDirectory;
    private File docDirectory;
    private File buildDirectory;
    private String artifactId;
    private String groupId;
    private String version;

    public void execute() throws MojoExecutionException {
        this.initialize();
        this.printHeader();
        JSONObject output = new JSONObject();
        JSONObject properties = new JSONObject();
        for (Map.Entry<String, String> entry : this.getDocumentation(this.docDirectory).entrySet()) {
            properties.put(entry.getKey(), (Object)entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.getWidgets(this.widgetDirectory).entrySet()) {
            properties.put(entry.getKey(), (Object)entry.getValue());
        }
        output.put("properties", (Object)properties);
        JSONArray artifacts = new JSONArray();
        for (String artifact : this.cdapArtifacts) {
            artifacts.put((Object)artifact);
        }
        output.put("parents", (Object)artifacts);
        try {
            File outputFile = new File(this.buildDirectory, this.artifactId + "-" + this.version + ".json");
            if (outputFile.exists()) {
                outputFile.delete();
            }
            outputFile.createNewFile();
            FileUtils.fileWrite((String)outputFile.getAbsolutePath(), (String)output.toString(2));
            this.getLog().info((CharSequence)("Successfully created  : " + this.project.getArtifactId() + "-" + this.project.getVersion() + ".json"));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        this.printFooter();
    }

    private Map<String, String> getWidgets(File directory) throws MojoExecutionException {
        TreeMap<String, String> properties = new TreeMap<String, String>();
        File[] files = directory.listFiles();
        HashMap<String, File> iconFiles = new HashMap();
        if (this.iconDirectory.exists()) {
            iconFiles = this.getFileNameMap(this.iconDirectory.listFiles());
        }
        for (File file : files) {
            if (!file.isFile()) {
                this.getLog().warn((CharSequence)String.format("Widget path '%s' is not a file. Skipping", file.getPath()));
                continue;
            }
            String ext = FileUtils.extension((String)file.getName());
            if (!ext.equalsIgnoreCase("json")) {
                this.getLog().warn((CharSequence)String.format("Skipping non JSON file '%s'", file.getName()));
                continue;
            }
            String name = file.getName();
            try {
                JSONTokener tokener = new JSONTokener(FileUtils.fileRead((File)file.getAbsoluteFile(), (String)"UTF-8"));
                JSONObject object = new JSONObject(tokener);
                String fileName = FileUtils.removeExtension((String)name);
                this.addIcon(object, iconFiles, fileName);
                properties.put(String.format("%s.%s", "widgets", fileName), object.toString(2));
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException(String.format("Unable to access Widget file '%s' or not found. %s", file.getName(), e.getMessage()));
            }
            catch (JSONException e) {
                throw new MojoExecutionException(String.format("Widget file '%s' has incorrect JSON. %s", file.getName(), e.getMessage()));
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Issue reading Widget file '%s'. %s", file.getName(), e.getMessage()));
            }
        }
        return properties;
    }

    private void addIcon(JSONObject widgetsJson, Map<String, File> iconFiles, String fileName) throws IOException {
        if (iconFiles.containsKey(fileName)) {
            JSONObject iconObject = new JSONObject();
            iconObject.put("type", (Object)"inline");
            TreeMap<String, String> arguments = new TreeMap<String, String>();
            File file = iconFiles.get(fileName);
            String mediaType = URLConnection.guessContentTypeFromName(file.getName());
            arguments.put("data", this.getDataURISchemaAsString(file, mediaType));
            iconObject.put("arguments", arguments);
            widgetsJson.put("icon", (Object)iconObject);
        }
    }

    /*
     * Exception decompiling
     */
    private String getDataURISchemaAsString(File file, String mediaType) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, File> getFileNameMap(File[] listFiles) {
        HashMap<String, File> names = new HashMap<String, File>();
        if (listFiles != null) {
            for (File file : listFiles) {
                String fileName = FileUtils.removeExtension((String)file.getName());
                if (names.containsKey(fileName)) {
                    this.getLog().warn((CharSequence)String.format("'%s' is being ignored. '%s' will be used.", file.getName(), ((File)names.get(fileName)).getName()));
                    continue;
                }
                names.put(fileName, file);
            }
        }
        return names;
    }

    private Map<String, String> getDocumentation(File directory) throws MojoExecutionException {
        File[] files;
        TreeMap<String, String> properties = new TreeMap<String, String>();
        for (File file : files = directory.listFiles()) {
            if (!file.isFile()) {
                this.getLog().warn((CharSequence)String.format("Documentation path '%s' is not a file. Skipping", file.getPath()));
                continue;
            }
            String ext = FileUtils.extension((String)file.getName());
            if (!ext.equalsIgnoreCase("md")) {
                this.getLog().warn((CharSequence)String.format("Skipping non JSON file '%s'", file.getName()));
                continue;
            }
            String name = file.getName();
            try {
                properties.put(String.format("%s.%s", "doc", FileUtils.removeExtension((String)name)), FileUtils.fileRead((File)file.getAbsoluteFile(), (String)"UTF-8"));
            }
            catch (FileNotFoundException e) {
                throw new MojoExecutionException(String.format("Unable to access Documentation file '%s' or not found. %s", file.getName(), e.getMessage()));
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Issue reading Documentation file '%s'. %s", file.getName(), e.getMessage()));
            }
        }
        return properties;
    }

    private void initialize() throws MojoExecutionException {
        this.groupId = this.project.getGroupId();
        this.artifactId = this.project.getArtifactId();
        this.version = this.project.getVersion();
        this.baseDirectory = this.project.getBasedir();
        this.buildDirectory = new File(this.project.getBuild().getDirectory());
        this.widgetDirectory = this.getAndValidate(this.baseDirectory, this.widgetsDirectory);
        if (this.widgetDirectory == null) {
            throw new MojoExecutionException("CDAP plugin requires a 'widgets' directory to be present.");
        }
        this.iconDirectory = this.getAndValidate(this.baseDirectory, this.iconsDirectory);
        if (this.iconDirectory == null) {
            throw new MojoExecutionException("CDAP plugin requires a 'icons' directory to be present.");
        }
        this.docDirectory = this.getAndValidate(this.baseDirectory, this.docsDirectory);
        if (this.docDirectory == null) {
            throw new MojoExecutionException("CDAP plugin requires a 'docs' directory to be present.");
        }
    }

    private File getAndValidate(File baseDirectory, String directoryPath) {
        File directory = directoryPath.startsWith("/") ? new File(directoryPath) : new File(baseDirectory, directoryPath);
        if (!directory.exists()) {
            return null;
        }
        if (!directory.isDirectory()) {
            return null;
        }
        return directory;
    }

    private void printHeader() {
        this.getLog().info((CharSequence)this.repeat("-", 72));
        this.getLog().info((CharSequence)"CDAP Plugin JSON");
        this.getLog().info((CharSequence)this.repeat("-", 72));
        this.getLog().info((CharSequence)("Project              : " + this.project.getName()));
        this.getLog().info((CharSequence)("Group ID             : " + this.project.getGroupId()));
        this.getLog().info((CharSequence)("Artifact ID          : " + this.project.getArtifactId()));
        this.getLog().info((CharSequence)("Version              : " + this.project.getVersion()));
        this.getLog().info((CharSequence)("Base Directory       : " + this.project.getBasedir()));
        this.getLog().info((CharSequence)("Build Directory      : " + this.project.getBuild().getDirectory()));
        this.getLog().info((CharSequence)("Widgets Directory    : " + this.widgetDirectory.getPath()));
        this.getLog().info((CharSequence)("Icons Directory      : " + this.iconDirectory.getPath()));
        this.getLog().info((CharSequence)("Docs Directory       : " + this.docDirectory.getPath()));
        this.getLog().info((CharSequence)"CDAP Artifacts");
        for (String artifact : this.cdapArtifacts) {
            this.getLog().info((CharSequence)(" " + artifact));
        }
        this.getLog().info((CharSequence)this.repeat("-", 72));
    }

    private void printFooter() {
        this.getLog().info((CharSequence)this.repeat("-", 72));
    }

    private String repeat(String text, int numRepetitions) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < numRepetitions; ++i) {
            builder.append(text);
        }
        return builder.toString();
    }
}

