/*
 * Decompiled with CFR 0.152.
 */
package co.boorse.seleniumtable;

import co.boorse.seleniumtable.ElementContainerImpl;
import co.boorse.seleniumtable.LazyIterator;
import co.boorse.seleniumtable.SeleniumTableCell;
import co.boorse.seleniumtable.SeleniumTableRow;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.WebElement;

class SeleniumTableRowImpl
extends ElementContainerImpl
implements SeleniumTableRow {
    SeleniumTableRowImpl(WebElement element) {
        super(element);
    }

    @Override
    public SeleniumTableCell get(int columnIndex) {
        Optional<WebElement> elementOptional = this.findChild("(.//td|.//th)[" + (columnIndex + 1) + "]");
        WebElement element = elementOptional.orElseThrow(() -> new IndexOutOfBoundsException("Column index " + columnIndex + " too large for row."));
        return SeleniumTableCell.getInstance(element);
    }

    @Override
    public int cellCount() {
        List<WebElement> cellElements = this.findChildren(".//td|.//th");
        return cellElements.size();
    }

    @Override
    @Nonnull
    public Iterator<SeleniumTableCell> iterator() {
        return new LazyIterator<SeleniumTableCell>(0, this.cellCount(), this::get);
    }

    @Override
    public List<SeleniumTableCell> cells() {
        List<WebElement> cells = this.findChildren(".//td|.//th");
        return cells.stream().map(SeleniumTableCell::getInstance).collect(Collectors.toList());
    }

    @Override
    public boolean isHeaderRow() {
        List<WebElement> headerCells = this.findChildren(".//th");
        return headerCells.size() == this.cellCount();
    }
}

