/*
 * Decompiled with CFR 0.152.
 */
package co.boorse.seleniumtable;

import co.boorse.seleniumtable.ElementContainerImpl;
import co.boorse.seleniumtable.SeleniumTableCell;
import co.boorse.seleniumtable.SeleniumTableRow;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.WebElement;

class SeleniumTableRowImpl
extends ElementContainerImpl
implements SeleniumTableRow {
    SeleniumTableRowImpl(WebElement element) {
        super(element);
    }

    @Override
    public SeleniumTableCell get(int columnIndex) {
        List<SeleniumTableCell> cells = this.cells();
        if (columnIndex > cells.size() - 1) {
            throw new IndexOutOfBoundsException("Column index " + columnIndex + " too large for row with " + cells.size() + " cells.");
        }
        return cells.get(columnIndex);
    }

    @Override
    public int cellCount() {
        return this.cells().size();
    }

    @Override
    @Nonnull
    public Iterator<SeleniumTableCell> iterator() {
        return this.cells().iterator();
    }

    @Override
    public void forEach(Consumer<? super SeleniumTableCell> action) {
        this.cells().forEach(action);
    }

    @Override
    public Spliterator<SeleniumTableCell> spliterator() {
        return this.cells().spliterator();
    }

    @Override
    public List<SeleniumTableCell> cells() {
        List<WebElement> cells = this.findChildren(".//td|.//th");
        return cells.stream().map(SeleniumTableCell::getInstance).collect(Collectors.toList());
    }

    @Override
    public boolean isHeaderRow() {
        return this.cells().stream().allMatch(SeleniumTableCell::isHeaderCell);
    }
}

