/*
 * Decompiled with CFR 0.152.
 */
package co.boorse.seleniumtable;

import co.boorse.seleniumtable.ElementContainerImpl;
import co.boorse.seleniumtable.SeleniumTable;
import co.boorse.seleniumtable.SeleniumTableCell;
import co.boorse.seleniumtable.SeleniumTableRow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.openqa.selenium.WebElement;

class SeleniumTableImpl
extends ElementContainerImpl
implements SeleniumTable {
    SeleniumTableImpl(WebElement tableElement) {
        super(tableElement);
        String tagName = this.getElement().getTagName();
        String[] allowedTags = new String[]{"table", "tbody", "thead", "tfoot"};
        if (!Arrays.asList(allowedTags).contains(tagName.toLowerCase())) {
            throw new IllegalArgumentException("Invalid element of type \"" + tagName + "\" provided. Should be \"table\"");
        }
    }

    @Override
    public int rowCount() {
        return this.rows().size();
    }

    @Override
    public SeleniumTableRow get(int rowIndex) {
        List<SeleniumTableRow> rows = this.rows();
        if (rowIndex > rows.size() - 1) {
            throw new IndexOutOfBoundsException("Row index " + rowIndex + " too large for table with " + rows.size() + " rows.");
        }
        return rows.get(rowIndex);
    }

    @Override
    public SeleniumTableCell get(int rowIndex, int columnIndex) {
        return this.get(rowIndex).get(columnIndex);
    }

    @Override
    @Nonnull
    public Iterator<SeleniumTableRow> iterator() {
        return this.rows().iterator();
    }

    @Override
    public void forEach(Consumer<? super SeleniumTableRow> action) {
        this.rows().forEach(action);
    }

    @Override
    public Spliterator<SeleniumTableRow> spliterator() {
        return this.rows().spliterator();
    }

    @Override
    public SeleniumTable head() {
        Optional<WebElement> thead = this.findChild(".//thead");
        WebElement theadElement = thead.orElseThrow(() -> new NoSuchElementException("No element of type \"thead\" found on table."));
        return new SeleniumTableImpl(theadElement);
    }

    @Override
    public SeleniumTable body() {
        Optional<WebElement> tbody = this.findChild(".//tbody");
        WebElement theadElement = tbody.orElseThrow(() -> new NoSuchElementException("No element of type \"tbody\" found on table."));
        return new SeleniumTableImpl(theadElement);
    }

    @Override
    public SeleniumTable foot() {
        Optional<WebElement> tfoot = this.findChild(".//tfoot");
        WebElement theadElement = tfoot.orElseThrow(() -> new NoSuchElementException("No element of type \"tfoot\" found on table."));
        return new SeleniumTableImpl(theadElement);
    }

    @Override
    public boolean hasTBody() {
        return this.findChild(".//tbody").isPresent();
    }

    @Override
    public boolean hasTHead() {
        return this.findChild(".//thead").isPresent();
    }

    @Override
    public boolean hasTFoot() {
        return this.findChild(".//tfoot").isPresent();
    }

    @Override
    public List<SeleniumTableRow> rows() {
        List<WebElement> elements = this.findChildren(".//" + (this.hasTBody() ? "tbody/tr" : "tr"));
        return elements.stream().map(SeleniumTableRow::getInstance).collect(Collectors.toList());
    }

    @Override
    public boolean hasHeaderRow() {
        return this.headerRow() != null;
    }

    @Override
    public SeleniumTableRow headerRow() {
        SeleniumTableRow firstRow;
        SeleniumTable thead;
        if (this.hasTHead() && (thead = this.head()).rowCount() > 0 && (firstRow = thead.get(0)).isHeaderRow()) {
            return firstRow;
        }
        List<SeleniumTableRow> rows = this.rows();
        return rows.stream().filter(SeleniumTableRow::isHeaderRow).findFirst().orElse(null);
    }

    @Override
    public String getCaption() {
        Optional<WebElement> caption = this.findChild(".//caption");
        return caption.map(WebElement::getText).orElse(null);
    }

    @Override
    public boolean hasCaption() {
        return this.getCaption() != null;
    }

    @Override
    public List<SeleniumTableCell> getColumn(String columnName) {
        int foundIndex = this.getColumnIndex(columnName);
        if (foundIndex == -1) {
            throw new IllegalArgumentException("Unable to find column named \"" + columnName + "\" in table.");
        }
        ArrayList<SeleniumTableCell> columnCells = new ArrayList<SeleniumTableCell>();
        for (SeleniumTableRow row : this.rows()) {
            if (row.isHeaderRow()) continue;
            try {
                SeleniumTableCell cell = row.get(foundIndex);
                columnCells.add(cell);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return columnCells;
    }

    @Override
    public boolean hasColumn(String columnName) {
        return this.getColumnIndex(columnName) > -1;
    }

    private int getColumnIndex(String columnName) {
        SeleniumTableRow headerRow = this.headerRow();
        if (headerRow == null) {
            throw new UnsupportedOperationException("Cannot get cells for column \"" + columnName + "\" on table without header row.");
        }
        int foundIndex = -1;
        for (int i = 0; i < headerRow.cellCount(); ++i) {
            if (!headerRow.get(i).getText().equalsIgnoreCase(columnName)) continue;
            foundIndex = i;
            break;
        }
        return foundIndex;
    }
}

