package co.bittub.prime.repository.reactor;

import co.bittub.prime.common.PrimeMapConvertible;
import org.springframework.data.domain.Pageable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface PrimeRepository<T extends PrimeMapConvertible> extends CrudRepository<T> {
    Mono<T> findById(Long id);
    default Mono<T> findById(String id) {
        return Mono.error(new UnsupportedOperationException());
    }

    default Flux<T> findAll() {
        return Flux.error(new UnsupportedOperationException());
    }
    default Flux<T> findAll(Pageable pageable) {
        return Flux.error(new UnsupportedOperationException());
    }
}
