package co.bittub.ares.cache.redis.config;

import co.bittub.ares.cache.redis.RedisListCacheHandler;
import co.bittub.prime.cache.redis.ListCacheHandler;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.time.Duration;

@Configuration
public class RedisBeanConfig {
    @Value("${spring.redis.host:localhost}")
    private String redisHost;

    @Value("${spring.redis.port:6379}")
    private int redisPort;

    @Bean
    @ConditionalOnMissingBean
    public RedisClient redisClient() {
        RedisClient client = RedisClient.create(RedisURI.create(redisHost, redisPort));
        client.setDefaultTimeout(Duration.ofSeconds(20));
        return client;
    }

    @Bean
    @ConditionalOnMissingBean
    public ListCacheHandler listCacheHandler() {
        return new RedisListCacheHandler(redisClient());
    }
}
