package co.bittub.ares.cache.redis;

import co.bittub.prime.cache.CacheItem;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RedisListCacheHandler extends RedisAbstractCacheHandler {

    @Autowired
    public RedisListCacheHandler(RedisClient client) {
        super(client);
    }

    public long lpush(String key, String... values) {
        StatefulRedisConnection<String, String> connection = client.connect();
        RedisCommands<String, String> commands = connection.sync();
        long count = commands.lpush(key, values);
        connection.close();

        return count;
    }

    public List<String> range(String key, long start, long stop) {
        StatefulRedisConnection<String, String> connection = client.connect();
        RedisCommands<String, String> commands = connection.sync();
        List<String> values = commands.lrange(key, start, stop);
        connection.close();

        return values;
    }

    public long rpush(String key, String... values) {
        StatefulRedisConnection<String, String> connection = getConnection();
        RedisCommands<String, String> commands = connection.sync();
        long count = commands.rpush(key, values);
        connection.close();

        return count;
    }

    public CacheItem lpop(String key) {
        StatefulRedisConnection<String, String> connection = getConnection();
        RedisCommands<String, String> commands = connection.sync();
        CacheItem item = CacheItem.newInstance(key, commands.lpop(key));
        connection.close();

        return item;
    }

    public CacheItem rpop(String key) {
        StatefulRedisConnection<String, String> connection = getConnection();
        RedisCommands<String, String> commands = connection.sync();
        CacheItem item = CacheItem.newInstance(key, commands.rpop(key));
        connection.close();

        return item;
    }

    public long size(String key) {
        StatefulRedisConnection<String, String> connection = getConnection();
        RedisCommands<String, String> commands = connection.sync();
        Long size = commands.llen(key);
        connection.close();

        return size;
    }
}
