/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.util.network;

import co.aurasphere.botmill.kik.KikBotMillContext;
import co.aurasphere.botmill.kik.exception.KikError;
import co.aurasphere.botmill.kik.exception.KikErrorMessage;
import co.aurasphere.botmill.kik.util.json.JsonUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkUtils {
    private static final Logger logger = LoggerFactory.getLogger(NetworkUtils.class);

    public static String postJsonConfig(Object input) {
        StringEntity stringEntity = NetworkUtils.toStringEntity(input);
        HttpPost post = new HttpPost("https://api.kik.com/v1/config");
        post.setHeader("Content-Type", "application/json");
        post.setEntity((HttpEntity)stringEntity);
        return NetworkUtils.send((HttpRequestBase)post);
    }

    public static String postJsonMessage(Object input) {
        StringEntity stringEntity = NetworkUtils.toStringEntity(input);
        HttpPost post = new HttpPost("https://api.kik.com/v1/message");
        post.setHeader("Content-Type", "application/json");
        post.setEntity((HttpEntity)stringEntity);
        return NetworkUtils.send((HttpRequestBase)post);
    }

    public static String postJsonMessageBroadcast(Object input) {
        StringEntity stringEntity = NetworkUtils.toStringEntity(input);
        HttpPost post = new HttpPost("https://api.kik.com/v1/broadcast");
        post.setHeader("Content-Type", "application/json");
        post.setEntity((HttpEntity)stringEntity);
        return NetworkUtils.send((HttpRequestBase)post);
    }

    public static String getJsonUserMessage(String username) {
        HttpGet post = new HttpGet("https://api.kik.com/v1/user/" + username);
        post.setHeader("Content-Type", "application/json");
        return NetworkUtils.send((HttpRequestBase)post);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String send(HttpRequestBase request) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(KikBotMillContext.getInstance().getUser(), KikBotMillContext.getInstance().getApiKey());
        provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
        logger.debug(request.getRequestLine().toString());
        CloseableHttpResponse httpResponse = null;
        String response = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)request);
            response = NetworkUtils.logResponse((HttpResponse)httpResponse);
        }
        catch (Exception e) {
            logger.error("Error during HTTP connection to Kik: ", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                logger.error("Error while closing HTTP connection: ", (Throwable)e);
            }
        }
        return response;
    }

    private static String logResponse(HttpResponse response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        String output = NetworkUtils.getResponseContent(response);
        logger.debug("HTTP Status Code: {}", (Object)statusCode);
        logger.debug("Response: {}", (Object)output);
        if (statusCode >= 400) {
            logger.error("HTTP connection failed with error code {}.", (Object)statusCode);
            KikErrorMessage errorMessage = JsonUtils.fromJson(output, KikErrorMessage.class);
            KikError error = errorMessage.getError();
            logger.error("Error message from Kik. Message: [{}]", (Object)error.getMessage());
        }
        return output;
    }

    private static String getResponseContent(HttpResponse response) throws IOException {
        InputStream inputStream = response.getEntity().getContent();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        InputStreamReader inputStreamReader = new InputStreamReader(bufferedInputStream);
        BufferedReader br = new BufferedReader(inputStreamReader);
        StringBuilder builder = new StringBuilder();
        String output = null;
        while ((output = br.readLine()) != null) {
            builder.append(output);
        }
        return builder.toString();
    }

    public static void delete(Object input) {
        StringEntity stringEntity = NetworkUtils.toStringEntity(input);
        NetworkUtils.delete(stringEntity);
    }

    public static String post(String url, StringEntity entity) {
        HttpPost post = new HttpPost(url);
        post.setHeader("Content-Type", "application/x-www-form-urlencoded");
        post.setEntity((HttpEntity)entity);
        return NetworkUtils.send((HttpRequestBase)post);
    }

    public static String get(String url) {
        HttpGet get = new HttpGet(url);
        return NetworkUtils.send((HttpRequestBase)get);
    }

    private static StringEntity toStringEntity(Object object) {
        StringEntity input = null;
        try {
            String json = JsonUtils.toJson(object);
            input = new StringEntity(json);
            input.setContentType("application/json");
            logger.debug("Request: {}", (Object)NetworkUtils.inputStreamToString(input.getContent()));
        }
        catch (Exception e) {
            logger.error("Error during JSON message creation: ", (Throwable)e);
        }
        return input;
    }

    private static String inputStreamToString(InputStream stream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        String resultString = null;
        while ((length = stream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        resultString = result.toString("UTF-8");
        return resultString;
    }
}

