/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.util.json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class LowerCaseTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        return new TypeAdapter<T>(){

            public T read(JsonReader in) throws IOException {
                JsonElement tree = (JsonElement)elementAdapter.read(in);
                this.afterRead(tree);
                return delegate.fromJsonTree(tree);
            }

            public void write(JsonWriter out, T value) throws IOException {
                JsonElement tree = delegate.toJsonTree(value);
                this.beforeWrite(value, tree);
                elementAdapter.write(out, (Object)tree);
            }

            protected void beforeWrite(T source, JsonElement toSerialize) {
            }

            protected void afterRead(JsonElement deserialized) {
                if (deserialized instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)deserialized;
                    Set entrySet = jsonObject.entrySet();
                    for (Map.Entry entry : entrySet) {
                        if (entry.getValue() instanceof JsonElement) {
                            if (!((String)entry.getKey()).equalsIgnoreCase("type")) continue;
                            String val = jsonObject.get((String)entry.getKey()).toString();
                            jsonObject.addProperty((String)entry.getKey(), val.toLowerCase());
                            continue;
                        }
                        this.afterRead((JsonElement)entry.getValue());
                    }
                }
            }
        };
    }
}

