/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.util.json;

import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.MessageCallback;
import co.aurasphere.botmill.kik.model.MessageType;
import co.aurasphere.botmill.kik.util.json.CalendarSerializer;
import co.aurasphere.botmill.kik.util.json.EnumLowercaseSerializer;
import co.aurasphere.botmill.kik.util.json.IncomingMessagesDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Calendar;

public class JsonUtils {
    private static Gson gson;

    public static Gson getGson() {
        if (gson == null) {
            GsonBuilder builder = new GsonBuilder();
            builder.registerTypeHierarchyAdapter(Enum.class, (Object)new EnumLowercaseSerializer());
            builder.registerTypeHierarchyAdapter(MessageCallback.class, (Object)new IncomingMessagesDeserializer());
            builder.registerTypeHierarchyAdapter(Calendar.class, (Object)new CalendarSerializer());
            gson = builder.create();
        }
        return gson;
    }

    public static <T> T fromJson(String json, Class<T> T) {
        return (T)JsonUtils.getGson().fromJson(json, T);
    }

    public static String toJson(Object src) {
        return JsonUtils.getGson().toJson(src);
    }

    public static MessageType getType(String json) {
        Message message = (Message)JsonUtils.getGson().fromJson(json, Message.class);
        return message.getType();
    }
}

