/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.model;

import co.aurasphere.botmill.core.BotDefinition;
import co.aurasphere.botmill.core.BotMillSession;
import co.aurasphere.botmill.kik.KikBotMillContext;
import co.aurasphere.botmill.kik.builder.ActionFrameBuilder;
import co.aurasphere.botmill.kik.exception.BotMillMissingConfigurationException;
import co.aurasphere.botmill.kik.exception.KikBotMillException;
import co.aurasphere.botmill.kik.incoming.event.AnyEvent;
import co.aurasphere.botmill.kik.incoming.event.DeliveryReceiptEvent;
import co.aurasphere.botmill.kik.incoming.event.EventType;
import co.aurasphere.botmill.kik.incoming.event.FriendPickerEvent;
import co.aurasphere.botmill.kik.incoming.event.IsTypingEvent;
import co.aurasphere.botmill.kik.incoming.event.LinkMessageEvent;
import co.aurasphere.botmill.kik.incoming.event.MentionEvent;
import co.aurasphere.botmill.kik.incoming.event.PictureMessageEvent;
import co.aurasphere.botmill.kik.incoming.event.ScanDataEvent;
import co.aurasphere.botmill.kik.incoming.event.StartChattingEvent;
import co.aurasphere.botmill.kik.incoming.event.StickerEvent;
import co.aurasphere.botmill.kik.incoming.event.TextMessageEvent;
import co.aurasphere.botmill.kik.incoming.event.TextMessagePatternEvent;
import co.aurasphere.botmill.kik.incoming.event.VideoMessageEvent;
import co.aurasphere.botmill.kik.incoming.event.annotation.KikBotMillController;
import co.aurasphere.botmill.kik.incoming.event.annotation.KikBotMillInit;
import co.aurasphere.botmill.kik.model.ActionFrame;
import co.aurasphere.botmill.kik.model.Event;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.Reply;
import co.aurasphere.botmill.kik.util.properties.PropertiesUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KikBot
implements BotDefinition {
    private static final Logger logger = LoggerFactory.getLogger(KikBot.class);
    private static final String KIK_BOTMILL_PROPERTIES_FILENAME = "botmill.properties";
    private static final String KIK_BOTMILL_USER_NAME_PROP = "kik.user.name";
    private static final String KIK_BOTMILL_API_KEY_PROP = "kik.api.key";
    private static final String KIK_BOTMILL_USER_NAME_PROPERTY = "USERNAME";
    private static final String KIK_BOTMILL_API_KEY_PROPERTY = "API_KEY";
    private static final String KIK_BOTMILL_USER_NAME_PROP_PHOLDER = "<USERNAME>";
    private static final String KIK_BOTMILL_API_KEY_PROP_PHOLDER = "<API_KEY>";
    private ActionFrame actionFrame;
    private BotMillSession botMillSession;

    public KikBot() {
        try {
            this.buildKikBotConfig();
            this.buildAnnotatedInitDomain();
            this.buildAnnotatedBehaviour();
            this.defineBehaviour();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public void defineBehaviour() {
    }

    private void buildAnnotatedInitDomain() {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(KikBotMillInit.class)) continue;
            try {
                method.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    private void buildKikBotConfig() throws BotMillMissingConfigurationException {
        String kikApiKey;
        String kikUsername;
        Properties prop = PropertiesUtil.load(KIK_BOTMILL_PROPERTIES_FILENAME);
        try {
            kikUsername = prop.getProperty(KIK_BOTMILL_USER_NAME_PROP).equals("") || prop.getProperty(KIK_BOTMILL_USER_NAME_PROP).indexOf(KIK_BOTMILL_USER_NAME_PROP_PHOLDER) == 0 ? System.getenv(KIK_BOTMILL_USER_NAME_PROPERTY) : prop.getProperty(KIK_BOTMILL_USER_NAME_PROP);
            kikApiKey = prop.getProperty(KIK_BOTMILL_API_KEY_PROP).equals("") || prop.getProperty(KIK_BOTMILL_API_KEY_PROP).indexOf(KIK_BOTMILL_API_KEY_PROP_PHOLDER) == 0 ? System.getenv(KIK_BOTMILL_API_KEY_PROPERTY) : prop.getProperty(KIK_BOTMILL_API_KEY_PROP);
        }
        catch (Exception e) {
            logger.error("Make sure that kik.user.name and kik.api.key properties exist on the property file");
            return;
        }
        if (kikUsername == null || kikApiKey == null) {
            logger.error("Kik-BotMill Configuration is missing (botmill.properties). Please check if the appropriate property values are configured correctly.");
        }
        KikBotMillContext.getInstance().setup(kikUsername, kikApiKey);
        this.botMillSession = BotMillSession.getInstance();
    }

    private void buildAnnotatedBehaviour() throws KikBotMillException {
        Method[] methods;
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.isAnnotationPresent(KikBotMillController.class)) continue;
            KikBotMillController botMillController = method.getAnnotation(KikBotMillController.class);
            try {
                this.actionFrame = new ActionFrame();
                String textOrPattern = "";
                textOrPattern = !botMillController.text().equals("") ? botMillController.text() : botMillController.pattern();
                this.actionFrame.setEvent(this.toEvent(botMillController.eventType(), textOrPattern));
                method.invoke((Object)this, new Object[0]);
                KikBotMillContext.getInstance().addActionFrameToContext(this.actionFrame);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected final BotMillSession botMillSession() {
        return this.botMillSession;
    }

    protected final void reply(Reply<? extends Message> reply) {
        this.actionFrame.addReply(reply);
    }

    protected final void addActionFrame(Event event, Reply<? extends Message> reply) {
        ActionFrameBuilder.getInstance().setEvent(event).addReply(reply).buildToContext();
    }

    protected final void addActionFrame(Event event, List<Reply<? extends Message>> replies) {
        ActionFrameBuilder.getInstance().setEvent(event).addReplies(replies).buildToContext();
    }

    @SafeVarargs
    protected final void addActionFrame(Event event, Reply<? extends Message> ... replies) {
        ActionFrameBuilder.getInstance().setEvent(event).addReplies(replies).buildToContext();
    }

    protected ActionFrameBuilder actionFrameBuilder() {
        return ActionFrameBuilder.getInstance();
    }

    private Event toEvent(EventType eventType, String textOrPattern) {
        switch (eventType) {
            case ANY: {
                return new AnyEvent();
            }
            case DELIVERY_RECEIPT: {
                return new DeliveryReceiptEvent();
            }
            case FRIEND_PICKER: {
                return new FriendPickerEvent();
            }
            case IS_TYPING: {
                return new IsTypingEvent();
            }
            case LINK: {
                return new LinkMessageEvent();
            }
            case MENTION: {
                return new MentionEvent();
            }
            case PICTURE: {
                return new PictureMessageEvent();
            }
            case SCAN_DATA: {
                return new ScanDataEvent();
            }
            case START_CHATTING: {
                return new StartChattingEvent();
            }
            case STICKER: {
                return new StickerEvent();
            }
            case TEXT_MESSAGE: {
                return new TextMessageEvent().setText(textOrPattern);
            }
            case TEXT_PATTERN: {
                return new TextMessagePatternEvent().setPattern(textOrPattern);
            }
            case VIDEO: {
                return new VideoMessageEvent();
            }
        }
        return null;
    }
}

