/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.factory;

import co.aurasphere.botmill.kik.model.Attribution;
import co.aurasphere.botmill.kik.model.Keyboard;
import co.aurasphere.botmill.kik.model.KeyboardType;
import co.aurasphere.botmill.kik.model.KikJsData;
import co.aurasphere.botmill.kik.model.Response;
import co.aurasphere.botmill.kik.model.ResponseType;
import java.util.List;
import java.util.Map;

public class MessageFactory {
    public static Attribution createAttribution(String name, String iconUrl) {
        return new Attribution(name, iconUrl);
    }

    public static KikJsData createKikJsData() {
        return new KikJsData();
    }

    public static Response createTextResponse(String body) {
        return new Response(body, ResponseType.TEXT);
    }

    public static Response createFriendPickerResponse(String body, int min, int max, List<String> preselected) {
        Response response = new Response(body, ResponseType.FRIEND_PICKER);
        response.setMin(min);
        response.setMax(max);
        response.setPreselected(preselected);
        return response;
    }

    public static Response createPictureResponse(String picUrl, Map<String, String> metadata) {
        Response response = new Response(picUrl, metadata, ResponseType.PICTURE);
        return response;
    }

    public static Keyboard createStaticKeyboard(KeyboardType keyboardType, Response response) {
        return new Keyboard();
    }
}

