/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.builder;

import co.aurasphere.botmill.kik.model.BaseBuilder;
import co.aurasphere.botmill.kik.model.Buildable;
import co.aurasphere.botmill.kik.model.Keyboard;
import co.aurasphere.botmill.kik.model.MediaAttribution;
import co.aurasphere.botmill.kik.model.MessageType;
import co.aurasphere.botmill.kik.outgoing.model.PictureMessage;

public class PictureMessageBuilder
extends BaseBuilder
implements Buildable<PictureMessage> {
    private static PictureMessage pictureMessage;
    private static PictureMessageBuilder instance;

    public static PictureMessageBuilder getInstance() {
        if (instance == null) {
            instance = new PictureMessageBuilder();
        }
        pictureMessage = new PictureMessage();
        pictureMessage.setType(MessageType.PICTURE);
        return instance;
    }

    public PictureMessageBuilder() {
        pictureMessage = new PictureMessage();
        pictureMessage.setType(MessageType.PICTURE);
    }

    public PictureMessageBuilder setTo(String to) {
        pictureMessage.setTo(to);
        return this;
    }

    public PictureMessageBuilder setPicUrl(String picUrl) {
        pictureMessage.setPicUrl(picUrl);
        return this;
    }

    public PictureMessageBuilder setDelay(Integer delay) {
        pictureMessage.setDelay(delay);
        return this;
    }

    public PictureMessageBuilder addKeyboard(Keyboard keyboard) {
        pictureMessage.addKeyboard(keyboard);
        return this;
    }

    @Override
    public PictureMessage build() {
        pictureMessage.setAttribution(MediaAttribution.GALLERY);
        return pictureMessage;
    }
}

