/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.builder;

import co.aurasphere.botmill.kik.model.Attribution;
import co.aurasphere.botmill.kik.model.BaseBuilder;
import co.aurasphere.botmill.kik.model.Buildable;
import co.aurasphere.botmill.kik.model.Keyboard;
import co.aurasphere.botmill.kik.model.KikJsData;
import co.aurasphere.botmill.kik.model.MessageType;
import co.aurasphere.botmill.kik.outgoing.model.LinkMessage;

public class LinkMessageBuilder
extends BaseBuilder
implements Buildable<LinkMessage> {
    private static LinkMessage linkMessage;
    private static LinkMessageBuilder instance;

    public static LinkMessageBuilder getInstance() {
        if (instance == null) {
            instance = new LinkMessageBuilder();
        }
        linkMessage = new LinkMessage();
        linkMessage.setType(MessageType.LINK);
        return instance;
    }

    public LinkMessageBuilder() {
        linkMessage = new LinkMessage();
        linkMessage.setType(MessageType.LINK);
    }

    public LinkMessageBuilder setUrl(String url) {
        linkMessage.setUrl(url);
        return this;
    }

    public LinkMessageBuilder setTitle(String title) {
        linkMessage.setTitle(title);
        return this;
    }

    public LinkMessageBuilder setText(String text) {
        linkMessage.setText(text);
        return this;
    }

    public LinkMessageBuilder setPicUrl(String picUrl) {
        linkMessage.setPicUrl(picUrl);
        return this;
    }

    public LinkMessageBuilder setNoForward(boolean noForward) {
        linkMessage.setNoForward(noForward);
        return this;
    }

    public LinkMessageBuilder setKikJsData(KikJsData kikJsData) {
        linkMessage.setKikJsData(kikJsData);
        return this;
    }

    public LinkMessageBuilder setAttribution(Attribution attribution) {
        linkMessage.setAttribution(attribution);
        return this;
    }

    public LinkMessageBuilder setDelay(Integer delay) {
        linkMessage.setDelay(delay);
        return this;
    }

    public LinkMessageBuilder addKeyboard(Keyboard keyboard) {
        linkMessage.addKeyboard(keyboard);
        return this;
    }

    @Override
    public LinkMessage build() {
        return linkMessage;
    }
}

