/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.builder;

import co.aurasphere.botmill.kik.configuration.Configuration;
import co.aurasphere.botmill.kik.model.BaseBuilder;
import co.aurasphere.botmill.kik.model.Keyboard;
import co.aurasphere.botmill.kik.util.network.NetworkUtils;

public class ConfigurationBuilder
extends BaseBuilder {
    private Configuration config = new Configuration();
    private static ConfigurationBuilder instance;

    public static ConfigurationBuilder getInstance() {
        if (instance == null) {
            instance = new ConfigurationBuilder();
        }
        return instance;
    }

    public ConfigurationBuilder setWebhook(String webhook) {
        this.config.setWebhook(webhook);
        return this;
    }

    public ConfigurationBuilder setManuallySendReadReceipts(boolean manuallySendReadReceipts) {
        this.config.getFeatures().setManuallySendReadReceipts(manuallySendReadReceipts);
        return this;
    }

    public ConfigurationBuilder setReceiveReadReceipts(boolean receiveReadReceipts) {
        this.config.getFeatures().setReceiveReadReceipts(receiveReadReceipts);
        return this;
    }

    public ConfigurationBuilder setReceiveIsTyping(boolean receiveIsTyping) {
        this.config.getFeatures().setReceiveIsTyping(receiveIsTyping);
        return this;
    }

    public ConfigurationBuilder setReceiveDeliveryReceipts(boolean receiveDeliveryReceipts) {
        this.config.getFeatures().setReceiveDeliveryReceipts(receiveDeliveryReceipts);
        return this;
    }

    public ConfigurationBuilder setStaticKeyboard(Keyboard keyboard) {
        this.config.setStaticKeyBoard(keyboard);
        return this;
    }

    public Configuration buildConfiguration() {
        NetworkUtils.postJsonConfig(this.config);
        return this.config;
    }
}

