/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.model;

import co.aurasphere.botmill.kik.KikBotMillContext;
import co.aurasphere.botmill.kik.builder.ActionFrameBuilder;
import co.aurasphere.botmill.kik.exception.KikBotMillException;
import co.aurasphere.botmill.kik.incoming.event.AnyEvent;
import co.aurasphere.botmill.kik.incoming.event.DeliveryReceiptEvent;
import co.aurasphere.botmill.kik.incoming.event.EventType;
import co.aurasphere.botmill.kik.incoming.event.FriendPickerEvent;
import co.aurasphere.botmill.kik.incoming.event.IsTypingEvent;
import co.aurasphere.botmill.kik.incoming.event.LinkMessageEvent;
import co.aurasphere.botmill.kik.incoming.event.MentionEvent;
import co.aurasphere.botmill.kik.incoming.event.PictureMessageEvent;
import co.aurasphere.botmill.kik.incoming.event.ScanDataEvent;
import co.aurasphere.botmill.kik.incoming.event.StartChattingEvent;
import co.aurasphere.botmill.kik.incoming.event.StickerEvent;
import co.aurasphere.botmill.kik.incoming.event.TextMessageEvent;
import co.aurasphere.botmill.kik.incoming.event.TextMessagePatternEvent;
import co.aurasphere.botmill.kik.incoming.event.VideoMessageEvent;
import co.aurasphere.botmill.kik.incoming.event.annotation.BotMillController;
import co.aurasphere.botmill.kik.incoming.event.annotation.BotMillDomain;
import co.aurasphere.botmill.kik.model.ActionFrame;
import co.aurasphere.botmill.kik.model.Domain;
import co.aurasphere.botmill.kik.model.Event;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.Reply;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class AbstractKikBot
implements Domain {
    private ActionFrame actionFrame;

    public AbstractKikBot() {
        try {
            this.buildAnnotatedDomain();
            this.buildDomain();
        }
        catch (KikBotMillException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void buildDomain() {
    }

    protected void buildAnnotatedDomain() throws KikBotMillException {
        Method[] methods = this.getClass().getMethods();
        if (!this.getClass().isAnnotationPresent(BotMillDomain.class)) {
            throw new KikBotMillException("Domain is not BotMillDomain annotated. Make sure the class " + this.getClass().getName() + " is annotated properly.");
        }
        for (Method method : methods) {
            if (!method.isAnnotationPresent(BotMillController.class)) continue;
            BotMillController botMillController = method.getAnnotation(BotMillController.class);
            try {
                this.actionFrame = new ActionFrame();
                String textOrPattern = "";
                textOrPattern = !botMillController.text().equals("") ? botMillController.text() : botMillController.pattern();
                this.actionFrame.setEvent(this.toEvent(botMillController.eventType(), textOrPattern));
                method.invoke((Object)this, new Object[0]);
                KikBotMillContext.getInstance().addActionFrameToContext(this.actionFrame);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected final void reply(Reply<? extends Message> reply) {
        this.actionFrame.addReply(reply);
    }

    protected final void addActionFrame(Event event, Reply<? extends Message> reply) {
        ActionFrameBuilder.getInstance().setEvent(event).addReply(reply).buildToContext();
    }

    protected final void addActionFrame(Event event, List<Reply<? extends Message>> replies) {
        ActionFrameBuilder.getInstance().setEvent(event).addReplies(replies).buildToContext();
    }

    protected final void addActionFrame(Event event, Reply<? extends Message> ... replies) {
        ActionFrameBuilder.getInstance().setEvent(event).addReplies(replies).buildToContext();
    }

    protected ActionFrameBuilder actionFrameBuilder() {
        return ActionFrameBuilder.getInstance();
    }

    private Event toEvent(EventType eventType, String textOrPattern) {
        switch (eventType) {
            case ANY: {
                return new AnyEvent();
            }
            case DELIVERY_RECEIPT: {
                return new DeliveryReceiptEvent();
            }
            case FRIEND_PICKER: {
                return new FriendPickerEvent();
            }
            case IS_TYPING: {
                return new IsTypingEvent();
            }
            case LINK: {
                return new LinkMessageEvent();
            }
            case MENTION: {
                return new MentionEvent();
            }
            case PICTURE: {
                return new PictureMessageEvent();
            }
            case SCAN_DATA: {
                return new ScanDataEvent();
            }
            case START_CHATTING: {
                return new StartChattingEvent();
            }
            case STICKER: {
                return new StickerEvent();
            }
            case TEXT_MESSAGE: {
                return new TextMessageEvent().setText(textOrPattern);
            }
            case TEXT_PATTERN: {
                return new TextMessagePatternEvent().setPattern(textOrPattern);
            }
            case VIDEO: {
                return new VideoMessageEvent();
            }
        }
        return null;
    }
}

