/*
 * Decompiled with CFR 0.152.
 */
package co.aurasphere.botmill.kik.model;

import co.aurasphere.botmill.kik.model.Command;
import co.aurasphere.botmill.kik.model.Event;
import co.aurasphere.botmill.kik.model.Message;
import co.aurasphere.botmill.kik.model.Reply;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFrame {
    protected Event event;
    protected List<Reply<? extends Message>> replies = new ArrayList<Reply<? extends Message>>();
    protected List<Command> preCommands = new ArrayList<Command>();
    protected List<Command> postCommands = new ArrayList<Command>();

    protected void processFrame(Message message) {
        this.processPreCommands();
        for (Reply<? extends Message> reply : this.replies) {
            reply.processReply(message);
        }
        this.processPostCommands();
    }

    protected void processPreCommands() {
        for (Command preCommand : this.preCommands) {
            preCommand.run();
        }
    }

    protected void processPostCommands() {
        for (Command postCommand : this.postCommands) {
            postCommand.run();
        }
    }
}

